.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)profil.2	6.2 (Berkeley) 5/14/86
.\"
.TH PROFIL 2 "May 14, 1986"
.UC 4
.SH NAME
profil \- execution time profile
.SH SYNOPSIS
.nf
.B profil(buff, bufsiz, offset, scale)
.B char *buff;
.B int bufsiz, offset, scale;
.fi
.SH DESCRIPTION
.I Buff
points to an area of core whose length (in bytes) is given by
.IR bufsiz .
After this call, the user's program counter (pc)
is examined each clock tick (10 milliseconds);
.I offset
is subtracted from it, and the result multiplied by
.IR scale .
If the resulting number corresponds to a word
inside
.I buff,
that word is incremented.
.PP
The scale is interpreted as an unsigned,
fixed-point fraction with 16 bits of fraction:
0x10000 gives a 1-1 mapping of pc's to words
in
.I buff;
0x8000 maps each pair of instruction words
together.
.PP
Profiling is turned off by giving a
.I scale
of 0 or 1.
It is rendered
ineffective by giving a
.I bufsiz
of 0.
Profiling is turned off when an
.I execve
is executed, but remains on in child and parent both
after a
.IR fork .
Profiling is turned off if an update in
.I buff
would cause a memory fault.
.SH "RETURN VALUE
A 0, indicating success, is always returned.
.SH "SEE ALSO"
gprof(1), setitimer(2), monitor(3)
