.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mount.2	6.3 (Berkeley) 8/26/85
.\"
.TH MOUNT 2 "August 26, 1985"
.UC 4
.SH NAME
mount, umount \- mount or remove file system
.SH SYNOPSIS
.nf
.ft B
mount(special, name, rwflag)
char *special, *name;
int rwflag;
.PP
.ft B
umount(special)
char *special;
.fi
.SH DESCRIPTION
.I Mount
announces to the system that a removable file system has
been mounted on
the block-structured special file
.I special;
from now on, references to file
.I name
will refer to
the root file on the newly mounted file system.
.I Special
and
.I name
are pointers to null-terminated strings
containing the appropriate path names.
.PP
.I Name
must exist already. 
.I Name
must be a directory.
Its old contents
are inaccessible while the file system
is mounted.
.PP
The
.I rwflag
argument determines whether
the file system can be written on; if it is 0 writing
is allowed, if non-zero no writing is done.
Physically write-protected and magnetic
tape file systems must be mounted read-only or
errors will occur when access times are updated,
whether or not any
explicit write is attempted.
.PP
.I Umount
announces to the system that the
.I special
file is no longer to contain a removable file system.
The associated file reverts to its ordinary interpretation.
.SH "RETURN VALUE
.I Mount
returns 0 if the action occurred, \-1 if
.I special
is inaccessible or not an appropriate file, if
.I name
does not exist, if
.I special
is already mounted, if
.I name
is in use, or if
there are already too many
file systems mounted.
.PP
.I Umount
returns 0 if the action occurred; \-1 if
if the special file is inaccessible or
does not have a mounted file system,
or if there are active files in the mounted 
file system.
.SH ERRORS
.I Mount
will fail when one of the following occurs:
.TP 15
[ENAMETOOLONG]
A component of either pathname exceeded 255 characters,
or the entire length of either path name exceeded 1023 characters.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating either pathname.
.TP 15
[EPERM]
The caller is not the super-user.
.TP 15
[ENOENT]
A component of \fIname\fP does not exist.
.TP 15
[ENODEV]
A component of \fIspecial\fP does not exist.
.TP 15
[ENOTBLK]
.I Special
is not a block device.
.TP 15
[ENXIO]
The major device number of 
.I special
is out of range (this indicates no device driver exists
for the associated hardware).
.TP 15
[ENOTDIR]
A component of \fIname\fP is not a directory,
or a path prefix of \fIspecial\fP is not a directory.
.TP 15
[EINVAL]
Either pathname contains a character with the high-order bit set.
.TP 15
[EINVAL]
The super block for the file system had a bad magic
number or an out of range block size.
.TP 15
[EBUSY]
Another process currently holds a reference to
.IR name ,
or \fIspecial\fP is already mounted.
.TP 15
[EMFILE]
No space remains in the mount table.
.TP 15
[ENOMEM]
Not enough memory was available to read the cylinder
group information for the file system.
.TP 15
[EIO]
An I/O error occurred while reading the super block or
cylinder group information.
.TP 15
[EFAULT]
\fISpecial\fP or \fIname\fP points outside the
process's allocated address space.
.PP
.I Umount
may fail with one of the following errors:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EPERM]
The caller is not the super-user.
.TP 15
[ENODEV]
.I Special
does not exist.
.TP 15
[ENOTBLK]
.I Special
is not a block device.
.TP 15
[ENXIO]
The major device number of 
.I special
is out of range (this indicates no device driver exists
for the associated hardware).
.TP 15
[EINVAL]
The requested device is not in the mount table.
.TP 15
[EBUSY]
A process is holding a reference to a file located
on the file system.
.TP 15
[EIO]
An I/O error occurred while writing the super block or
other cached file system information.
.TP 15
[EFAULT]
\fISpecial\fP points outside the process's allocated address space.
.SH "SEE ALSO"
mount(8), umount(8)
.SH BUGS
Some of the error codes need translation to more obvious messages.
