.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getsockname.2	6.1 (Berkeley) 5/15/85
.\"
.TH GETSOCKNAME 2 "May 15, 1985"
.UC 5
.SH NAME
getsockname \- get socket name
.SH SYNOPSIS
.nf
.PP
.ft B
getsockname(s, name, namelen)
int s;
struct sockaddr *name;
int *namelen;
.fi
.SH DESCRIPTION
.I Getsockname
returns the current 
.I name
for the specified socket.  The
.I namelen
parameter should be initialized to indicate
the amount of space pointed to by
.IR name .
On return it contains the actual size of the name
returned (in bytes).
.SH DIAGNOSTICS
A 0 is returned if the call succeeds, \-1 if it fails.
.SH ERRORS
The call succeeds unless:
.TP 15
[EBADF]
The argument \fIs\fP is not a valid descriptor.
.TP 15
[ENOTSOCK]
The argument \fIs\fP is a file, not a socket.
.TP 15
[ENOBUFS]
Insufficient resources were available in the system
to perform the operation.
.TP 15
[EFAULT]
The 
.I name
parameter points to memory not in a valid part of the
process address space.
.SH "SEE ALSO"
bind(2), socket(2)
.SH BUGS
Names bound to sockets in the UNIX domain are inaccessible;
.I getsockname
returns a zero length name.
