.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getpgrp.2	6.3 (Berkeley) 8/26/85
.\"
.TH GETPGRP 2 "August 26, 1985"
.UC 5
.SH NAME
getpgrp \- get process group
.SH SYNOPSIS
.ft B
.nf
pgrp = getpgrp(pid)
int pgrp;
int pid;
.fi
.ft R
.SH DESCRIPTION
The process group of the specified process is returned by
.I getpgrp.
If
.I pid
is zero, then the call applies to the current process.
.PP
Process groups are used for distribution of signals, and
by terminals to arbitrate requests for their input: processes
that have the same process group as the terminal are foreground
and may read, while others will block with a signal if they attempt
to read.
.PP
This call is thus used by programs such as
.IR csh (1)
to create
process groups
in implementing job control.
The TIOCGPGRP and TIOCSPGRP calls
described in
.IR tty (4)
are used to get/set the process group of the control terminal.
.SH "SEE ALSO"
setpgrp(2), getuid(2), tty(4)
