.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getpeername.2	6.2 (Berkeley) 5/13/86
.\"
.TH GETPEERNAME 2 "May 13, 1986"
.UC 5
.SH NAME
getpeername \- get name of connected peer
.SH SYNOPSIS
.nf
.PP
.ft B
getpeername(s, name, namelen)
int s;
struct sockaddr *name;
int *namelen;
.fi
.SH DESCRIPTION
.I Getpeername
returns the name of the peer connected to
socket
.IR s .
The
.I namelen
parameter should be initialized to indicate
the amount of space pointed to by
.IR name .
On return it contains the actual size of the name
returned (in bytes).
The name is truncated if the buffer provided is too small.
.SH DIAGNOSTICS
A 0 is returned if the call succeeds, \-1 if it fails.
.SH ERRORS
The call succeeds unless:
.TP 15
[EBADF]
The argument \fIs\fP is not a valid descriptor.
.TP 15
[ENOTSOCK]
The argument \fIs\fP is a file, not a socket.
.TP 15
[ENOTCONN]
The socket is not connected.
.TP 15
[ENOBUFS]
Insufficient resources were available in the system
to perform the operation.
.TP 15
[EFAULT]
The 
.I name
parameter points to memory not in a valid part of the
process address space.
.SH "SEE ALSO"
accept(2), bind(2), socket(2), getsockname(2)
