.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)gethostname.2	6.4 (Berkeley) 5/22/86
.\"
.TH GETHOSTNAME 2 "May 22, 1986"
.UC 5
.SH NAME
gethostname, sethostname \- get/set name of current host
.SH SYNOPSIS
.nf
.ft B
gethostname(name, namelen)
char *name;
int namelen;
.PP
.ft B
sethostname(name, namelen)
char *name;
int namelen;
.fi
.SH DESCRIPTION
.I Gethostname
returns the standard host name for the current processor, as
previously set by
.IR sethostname . 
The parameter
.I namelen
specifies the size of the 
.I name
array.  The returned name is null-terminated unless insufficient
space is provided.
.PP
.I Sethostname
sets the name of the host machine to be
.IR name ,
which has length
.IR namelen .
This call is restricted to the super-user and
is normally used only when the system is bootstrapped.
.SH "RETURN VALUE
If the call succeeds a value of 0 is returned.  If the call
fails, then a value of \-1 is returned and an error code is
placed in the global location \fIerrno\fP.
.SH "ERRORS
The following errors may be returned by these calls:
.TP 15
[EFAULT]
The \fIname\fP or \fInamelen\fP parameter gave an
invalid address.
.TP 15
[EPERM]
The caller tried to set the hostname and was not the super-user.
.SH SEE ALSO
gethostid(2)
.SH BUGS
Host names are limited to MAXHOSTNAMELEN (from
.IR <sys/param.h> )
characters, currently 64.
