.\"
.\" $Id: getdirentries.2,v 2.3 90/01/12 17:43:38 bww Exp $
.\"
.\" HISTORY
.\" $Log:	getdirentries.2,v $
.\" Revision 2.3  90/01/12  17:43:38  bww
.\" 	Deleted paragraph about getdirentries being obsolete.
.\" 	[90/01/12  17:43:02  bww]
.\" 
.\" Revision 2.2  89/12/27  13:00:04  bww
.\" 	Sun Microsystems Rel 3.0
.\" 	[89/12/27  12:59:57  bww]
.\" 
.\"
.\" @(#)getdirentries.2 1.1 85/12/28 SMI;
.\"
.TH GETDIRENTRIES 2 "27 May 1988"
.SU
.SH NAME
getdirentries \- gets directory entries in a filesystem independent format
.SH SYNOPSIS
.nf
.ft B
#include <sys/dir.h>
.LP
.ft B
cc = getdirentries(fd, buf, nbytes, basep)
int cc, fd;
char *buf;
int nbytes;
long *basep
.fi
.SH DESCRIPTION
.LP
.I Getdirentries
attempts to put directory entries from the directory referenced by
the file descriptor
.I fd
into the buffer pointed to by
.IR buf ,
in a filesystem independent format.  Up to
.I nbytes
of data will be transferred.
.I Nbytes
must be greater than or equal to the block size associated with the file, see
.IR stat(2) .
Sizes less than this may cause errors on certain filesystems.
.LP
The data in the buffer is a series of
.I direct
structures each containing the following entries:
.LP
.RS
.ta +\w'unsigned\0short\0'u +\w'd_name[MAXNAMELEN + 1];\0'u
.nf
unsigned long	d_fileno;
unsigned short	d_reclen;
unsigned short	d_namlen;
char    	d_name[MAXNAMELEN + 1];	/* see below */
.fi
.RE
.LP
The
.I d_fileno
entry is a number which is unique for each distinct file in the filesystem.
Files that are linked by hard links (see
.IR link(2) )
have the same
.IR d_fileno .
The
.I d_reclen
entry is the length, in bytes, of the directory record.
The
.I d_name
entry contains a null terminated file name.
The
.I d_namlen
entry specifies the length of the file name.
Thus the actual size of
.I d_name
may vary from 2 to (MAXNAMELEN + 1).
.LP
The structures are not necessarily tightly packed.
The
.I d_reclen
entry may be used as an offset from the beginning of a
.I direct
structure to the next structure, if any.
.LP
Upon return, the actual number of bytes transferred is returned.
The current position pointer associated with
.I fd
is set to point to the next block of entries.
The pointer is not necessarily incremented by the number of bytes returned by
.IR getdirentries .
If the value returned is zero, the end of the directory has been reached.
The current position pointer may be set and retrieved by
.IR lseek(2) .
.I Getdirentries
writes the position of the block read into the location pointed to by
.IR basep .
It is not safe to set the current position pointer to any value other than
a value previously returned by
.I lseek(2)
or a value previously returned in the location pointed to by
.I basep
or zero.
.SH "RETURN VALUE
If successful, the number of bytes actually transferred is returned.
Otherwise, a \-1 is returned and the global variable
.I errno
is set to indicate the error.
.SH "SEE ALSO"
open(2), lseek(2)
.SH ERRORS
.I Getdirentries
will fail if one or more of the following are true:
.TP 15
[EBADF]
\fIfd\fP is not a valid file descriptor open for reading.
.TP 15
[EFAULT]
Either \fIbuf\fP or \fIbasep\fP point outside the allocated address space.
.TP 15
[EINTR]
A read from a slow device was interrupted before
any data arrived by the delivery of a signal.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
