.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)fcntl.2	6.4 (Berkeley) 5/22/86
.\"
.TH FCNTL 2 "May 22, 1986"
.UC 5
.SH NAME
fcntl \- file control
.SH SYNOPSIS
.nf
.ft B
#include <fcntl.h>
.PP
.ft B
res = fcntl(fd, cmd, arg)
int res;
int fd, cmd, arg;
.ft R
.SH DESCRIPTION
.I Fcntl
provides for control over descriptors.
The argument
.I fd
is a descriptor to be operated on by
.I cmd
as follows:
.TP 15
F_DUPFD
Return a new descriptor as follows:
.IP
Lowest numbered available descriptor greater than or equal to
.I arg.
.IP
Same object references as the original descriptor.
.IP
New descriptor shares the same file pointer if the object
was a file.
.IP
Same access mode (read, write or read/write).
.IP
Same file status flags (i.e., both file descriptors
share the same file status flags).
.IP
The close-on-exec flag associated with the new file descriptor
is set to remain open across
.IR execv (2)
system calls.
.TP 15
F_GETFD
Get the close-on-exec flag associated with the file descriptor
.IR fd .
If the low-order bit is 0, the file will remain open across
.IR exec ,
otherwise the file will be closed upon execution of
.I exec.
.TP 15
F_SETFD
Set the close-on-exec flag associated with
.I fd
to the low order bit of
.I arg
(0 or 1 as above).
.TP 15
F_GETFL
Get descriptor status flags, as described below.
.TP 15
F_SETFL
Set descriptor status flags.
.TP 15
F_GETOWN
Get the process ID or process group
currently receiving SIGIO and SIGURG
signals; process groups are returned
as negative values.
.TP
F_SETOWN
Set the process or process group
to receive SIGIO and SIGURG signals;
process groups are specified by supplying
.I arg
as negative, otherwise 
.I arg
is interpreted as a process ID.
.LP
The flags for the F_GETFL and F_SETFL flags are as follows:
.TP 15
FNDELAY
Non-blocking I/O; if no data is available to a
.I read
call, or if a write operation would block,
the call returns -1 with the error EWOULDBLOCK.
.TP
FAPPEND
Force each write to append at the end of file;
corresponds to the O_APPEND flag of
.IR open (2).
.TP
FASYNC
Enable the SIGIO signal to be sent to the process group
when I/O is possible, e.g.,
upon availability of data to be read.
.SH "RETURN VALUE
Upon successful completion, the value returned depends on
.I cmd
as follows:
.sp .5v
.nf
.ta .25i 1.25i
	F_DUPFD	A new file descriptor.
	F_GETFD	Value of flag (only the low-order bit is defined).
	F_GETFL	Value of flags.
	F_GETOWN	Value of file descriptor owner.
	other	Value other than \-1.
.fi
.sp .5v
Otherwise, a value of \-1 is returned and
.I errno
is set to indicate the error.
.SH ERRORS
.I Fcntl
will fail if one or more of the following are true:
.TP 15
[EBADF]
.I Fildes
is not a valid open file descriptor.
.TP 15
[EMFILE]
.I Cmd
is F_DUPFD and the maximum allowed number of file descriptors are currently
open.
.TP 15
[EINVAL]
.I Cmd
is F_DUPFD and
.I arg
is negative or greater than the maximum allowable number
(see
.IR getdtablesize (2)).
.TP 15
[ESRCH]
.I Cmd
is F_SETOWN and
the process ID given as argument is not in use.
.SH "SEE ALSO
close(2), execve(2), getdtablesize(2), open(2), sigvec(2)
.SH BUGS
The asynchronous I/O facilities of FNDELAY and FASYNC
are currently available only for tty and socket operations.
