.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)execve.2	6.7 (Berkeley) 5/22/86
.\"
.TH EXECVE 2 "May 22, 1986"
.UC 4
.SH NAME
execve \- execute a file
.SH SYNOPSIS
.ft B
execve(name, argv, envp)
.br
char *name, *argv[], *envp[];
.fi
.SH DESCRIPTION
.I Execve
transforms the calling process into a new process.
The new process is constructed from an ordinary file
called the \fInew process file\fP.
This file is either an executable object file,
or a file of data for an interpreter.
An executable object file consists of an identifying header,
followed by pages of data representing the initial program (text)
and initialized data pages.  Additional pages may be specified
by the header to be initialized with zero data.  See
.IR a.out (5).
.PP
An interpreter file begins with a line of the form ``#! \fIinterpreter\fP''.
When an interpreter file is
.IR execve\| 'd,
the system \fIexecve\fP\|'s the specified \fIinterpreter\fP, giving
it the name of the originally exec'd file as an argument and
shifting over the rest of the original arguments.
.PP
There can be no return from a successful \fIexecve\fP because the calling
core image is lost.
This is the mechanism whereby different process images become active.
.PP
The argument \fIargv\fP is a null-terminated array of character pointers
to null-terminated character strings.  These strings constitute
the argument list to be made available to the new
process.  By convention, at least one argument must be present in
this array, and the first element of this array should be
the name of the executed program (i.e., the last component of \fIname\fP).
.PP
The argument \fIenvp\fP is also a null-terminated array of character pointers
to null-terminated strings.  These strings pass information to the
new process that is not directly an argument to the command (see
.IR environ (7)).
.PP
Descriptors open in the calling process remain open in
the new process, except for those for which the close-on-exec
flag is set (see
.IR close (2)).
Descriptors that remain open are unaffected by
.IR execve .
.PP
Ignored signals remain ignored across an
.IR execve ,
but signals that are caught are reset to their default values.
Blocked signals remain blocked regardless of changes to the signal action.
The signal stack is reset to be undefined (see
.IR sigvec (2) 
for more information).
.PP
Each process has
.I real
user and group IDs and an
.I effective
user and group IDs.  The
.I real
ID identifies the person using the system; the
.I effective
ID determines his access privileges.
.I Execve
changes the effective user and group ID to
the owner of the executed file if the file has the \*(lqset-user-ID\*(rq
or \*(lqset-group-ID\*(rq modes.  The
.I real
user ID is not affected.
.PP
The new process also inherits the following attributes from
the calling process:
.PP
.in +5n
.nf
.ta +2i
process ID	see \fIgetpid\fP\|(2)
parent process ID	see \fIgetppid\fP\|(2)
process group ID	see \fIgetpgrp\fP\|(2)
access groups	see \fIgetgroups\fP\|(2)
working directory	see \fIchdir\fP\|(2)
root directory	see \fIchroot\fP\|(2)
control terminal	see \fItty\fP\|(4)
resource usages	see \fIgetrusage\fP\|(2)
interval timers	see \fIgetitimer\fP\|(2)
resource limits	see \fIgetrlimit\fP\|(2)
file mode mask	see \fIumask\fP\|(2)
signal mask	see \fIsigvec\fP\|(2), \fIsigmask\fP\|(2)
.in -5n
.fi
.PP
When the executed program begins, it is called as follows:
.PP
.DT
.nf
	main(argc, argv, envp)
	int argc;
	char **argv, **envp;
.fi
.PP
where
.I argc
is the number of elements in \fIargv\fP
(the ``arg count'')
and
.I argv
is the array of character pointers
to the arguments themselves.
.PP
.I Envp
is a pointer to an array of strings that constitute
the
.I environment
of the process.
A pointer to this array is also stored in the global variable ``environ''.
Each string consists of a name, an \*(lq=\*(rq, and a null-terminated value.
The array of pointers is terminated by a null pointer.
The shell
.IR sh (1)
passes an environment entry for each global shell variable
defined when the program is called.
See
.IR environ (7)
for some conventionally
used names.
.SH "RETURN VALUE
If
.I execve
returns to the calling process an error has occurred; the
return value will be \-1 and the global variable
.I errno
will contain an error code.
.SH ERRORS
.I Execve
will fail and return to the calling process if one or more
of the following are true:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The new process file does not exist.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[EACCES]
The new process file is not an ordinary file.
.TP 15
[EACCES]
The new process file mode denies execute permission.
.TP 15
[ENOEXEC]
The new process file has the appropriate access
permission, but has an invalid magic number in its header.
.TP 15
[ETXTBSY]
The new process file is a pure procedure (shared text)
file that is currently open for writing or reading by some process.
.TP 15
[ENOMEM]
The new process requires more virtual memory than
is allowed by the imposed maximum
.RI ( getrlimit (2)).
.TP 15
[E2BIG]
The number of bytes in the new process's argument list
is larger than the system-imposed limit.
The limit in the system as released is 20480 bytes
(NCARGS in
.IR <sys/param.h> .
.TP 15
[EFAULT]
The new process file is not as long as indicated by
the size values in its header.
.TP 15
[EFAULT]
\fIPath\fP\|, \fIargv\fP\|, or \fIenvp\fP point
to an illegal address.
.TP 15
[EIO]
An I/O error occurred while reading from the file system.
.SH CAVEATS
If a program is
.I setuid
to a non-super-user, but is executed when
the real \fIuid\fP is ``root'', then the program has some of the powers
of a super-user as well.
.SH "SEE ALSO"
exit(2), fork(2), execl(3), environ(7)
