.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)creat.2	6.6 (Berkeley) 5/22/86
.\"
.TH CREAT 2 "May 22, 1986"
.UC 4
.SH NAME
creat \- create a new file
.SH SYNOPSIS
.nf
.B creat(name, mode)
.B char *name;
.fi
.SH DESCRIPTION
.B "This interface is made obsolete by open(2).
.PP
.I Creat
creates a new file or prepares to rewrite an existing
file called 
.IR name ,
given as the address of a null-terminated string.
If the file did not exist, it is given
mode
.IR mode ,
as modified by the process's mode mask (see
.IR umask (2)).
Also see
.IR  chmod (2)
for the
construction of the
.I mode
argument.
.PP
If the file did exist, its mode and owner remain unchanged
but it is truncated to 0 length.
.PP
The file is also opened for writing, and its file descriptor
is returned.
.SH NOTES
The
.I mode
given is arbitrary; it need not allow
writing.
This feature has been used in the past by
programs to construct a simple, exclusive locking
mechanism.  It is replaced by the O_EXCL open
mode, or 
.IR flock (2)
facility.  
.SH "RETURN VALUE
The value \-1 is returned if an error occurs.  Otherwise,
the call returns a non-negative descriptor that only permits
writing.
.SH ERRORS
.I Creat
will fail and the file will not be created or truncated
if one of the following occur:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named file does not exist.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[EACCES]
The file does not exist and the directory
in which it is to be created is not writable.
.TP 15
[EACCES]
The file exists, but it is unwritable.
.TP 15
[EISDIR]
The file is a directory.
.TP 15
[EMFILE]
There are already too many files open.
.TP 15
[ENFILE]
The system file table is full.
.TP 15
[ENOSPC]
The directory in which the entry for the new file is being placed
cannot be extended because there is no space left on the file
system containing the directory.
.TP 15
[ENOSPC]
There are no free inodes on the file system on which the
file is being created.
.TP 15
[EDQUOT]
The directory in which the entry for the new file
is being placed cannot be extended because the
user's quota of disk blocks on the file system
containing the directory has been exhausted.
.TP 15
[EDQUOT]
The user's quota of inodes on the file system on
which the file is being created has been exhausted.
.TP 15
[EROFS]
The named file resides on a read-only file system.
.TP 15
[ENXIO]
The file is a character special or block special file, and
the associated device does not exist.
.TP 15
[ETXTBSY]
The file is a pure procedure (shared text) file that is being
executed.
.TP 15
[EIO]
An I/O error occurred while making the directory entry or allocating the inode.
.TP 15
[EFAULT]
.I Name
points outside the process's allocated address space.
.TP 15
[EOPNOTSUPP]
The file was a socket (not currently implemented).
.SH "SEE ALSO"
open(2), write(2), close(2), chmod(2), umask(2)
