.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)chown.2	6.6 (Berkeley) 5/22/86
.\"
.TH CHOWN 2 "May 22, 1986"
.UC 4
.SH NAME
chown \- change owner and group of a file
.SH SYNOPSIS
.nf
.ft B
chown(path, owner, group)
char *path;
int owner, group;
.PP
.ft B
fchown(fd, owner, group)
int fd, owner, group;
.fi
.SH DESCRIPTION
The file
that is named by \fIpath\fP or referenced by \fIfd\fP
has its
.I owner
and 
.I group
changed as specified.
Only the super-user
may change the owner of the file,
because if users were able to give files away,
they could defeat the file-space accounting procedures.
The owner of the file may change the group
to a group of which he is a member.
.PP
On some systems,
.I chown
clears the set-user-id and set-group-id bits
on the file
to prevent accidental creation of
set-user-id and set-group-id programs.
.PP
.I Fchown
is particularly useful when used in conjunction
with the file locking primitives (see
.IR flock (2)).
.PP
One of the owner or group id's
may be left unchanged by specifying it as \-1.
.PP
If the final component of
.I path
is a symbolic link,
the ownership and group of the symbolic link is changed,
not the ownership and group of the file or directory to which it points.
.SH "RETURN VALUE
Zero is returned if the operation was successful;
\-1 is returned if an error occurs, with a more specific
error code being placed in the global variable \fIerrno\fP.
.SH "ERRORS
.I Chown
will fail and the file will be unchanged if:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named file does not exist.
.TP 15
[EACCES]
Search permission is denied for a component of the path prefix.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EPERM]
The effective user ID is not the super-user.
.TP 15
[EROFS]
The named file resides on a read-only file system.
.TP 15
[EFAULT]
.I Path
points outside the process's allocated address space.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.PP
.I Fchown
will fail if:
.TP 15
[EBADF]
.I Fd
does not refer to a valid descriptor.
.TP 15
[EINVAL]
.I Fd
refers to a socket, not a file.
.TP 15
[EPERM]
The effective user ID is not the super-user.
.TP 15
[EROFS]
The named file resides on a read-only file system.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.SH "SEE ALSO"
chown(8), chgrp(1), chmod(2), flock(2)
