.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)chdir.2	6.3 (Berkeley) 8/26/85
.\"
.TH CHDIR 2 "August 26, 1985"
.UC 4
.SH NAME
chdir \- change current working directory
.SH SYNOPSIS
.nf
.ft B
chdir(path)
char *path;
.ft R
.fi
.SH DESCRIPTION
.I Path
is the pathname of a directory.
.I Chdir
causes this directory
to become the current working directory,
the starting point for path names not beginning with ``/''.
.PP
In order for a directory to become the current directory,
a process must have execute (search) access to the directory.
.SH "RETURN VALUE
Upon successful completion, a value of 0 is returned.
Otherwise, a value of \-1 is returned and \fIerrno\fP is set to indicate
the error.
.SH ERRORS
.I Chdir
will fail and the current working directory will be unchanged if
one or more of the following are true:
.TP 15
[ENOTDIR]
A component of the path prefix is not a directory.
.TP 15
[EINVAL]
The pathname contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of a pathname exceeded 255 characters,
or an entire path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named directory does not exist.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EACCES]
Search permission is denied for any component of
the path name.
.TP 15
[EFAULT]
.I Path
points outside the process's allocated address space.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.SH "SEE ALSO"
chroot(2)
