.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)adjtime.2	1.5 (Berkeley) 7/9/88
.\"
.TH ADJTIME 2 "July 9, 1988"
.UC 6
.SH NAME
adjtime \- correct the time to allow synchronization of the system clock
.SH SYNOPSIS
.nf
.ft B
#include <sys/time.h>
.PP
.ft B
adjtime(delta, olddelta)
struct timeval *delta; 
struct timeval *olddelta;
.fi
.SH DESCRIPTION
.I Adjtime
makes small adjustments to the system time, as returned by
.IR gettimeofday (2),
advancing or retarding it
by the time specified by the timeval
\fIdelta\fP.
If \fIdelta\fP is negative, the clock is
slowed down by incrementing it more slowly than normal until
the correction is complete.
If \fIdelta\fP is positive, a larger increment than normal
is used.
The skew used to perform the correction is generally a fraction of one percent.
Thus, the time is always
a monotonically increasing function.
A time correction from an earlier call to \fIadjtime\fP
may not be finished when \fIadjtime\fP is called again.
If \fIolddelta\fP is non-zero,
then the structure pointed to will contain, upon return, the
number of microseconds still to be corrected
from the earlier call.
.PP
This call may be used by time servers that synchronize the clocks
of computers in a local area network.
Such time servers would slow down the clocks of some machines
and speed up the clocks of others to bring them to the average network time.
.PP
The call 
.IR adjtime (2)
is restricted to the super-user.
.SH "RETURN VALUE
A return value of 0 indicates that the call succeeded.
A return value of \-1 indicates that an error occurred, and in this
case an error code is stored in the global variable \fIerrno\fP.
.SH "ERRORS
The following error codes may be set in \fIerrno\fP:
.TP 15
[EFAULT]
An argument points outside the process's allocated address space.
.TP 15
[EPERM]
The process's effective user ID is not that of the super-user.
.SH "SEE ALSO"
date(1), gettimeofday(2), timed(8), timedc(8),
.br
\fITSP: The Time Synchronization Protocol for UNIX 4.3BSD\fP, 
R. Gusella and S. Zatti
