.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)accept.2	6.3 (Berkeley) 5/22/86
.\"
.TH ACCEPT 2 "May 22, 1986"
.UC 5
.SH NAME
accept \- accept a connection on a socket
.SH SYNOPSIS
.ft B
.nf
#include <sys/types.h>
#include <sys/socket.h>
.PP
.ft B
ns = accept(s, addr, addrlen)
int ns, s;
struct sockaddr *addr;
int *addrlen;
.fi
.SH DESCRIPTION
The argument
.I s
is a socket that has been created with
.IR socket (2),
bound to an address with
.IR bind (2),
and is listening for connections after a
.IR listen (2).
.I Accept
extracts the first connection
on the queue of pending connections, creates
a new socket with the same properties of 
.I s
and allocates a new file descriptor,
.IR ns ,
for the socket.  If no pending connections are
present on the queue, and the socket is not marked
as non-blocking,
.I accept
blocks the caller until a connection is present.
If the socket is marked non-blocking and no pending
connections are present on the queue, 
.I accept
returns an error as described below.
The accepted socket,
.IR ns ,
may not be used
to accept more connections.  The original socket
.I s
remains open.
.PP
The argument
.I addr
is a result parameter that is filled in with
the address of the connecting entity,
as known to the communications layer.
The exact format of the
.I addr
parameter is determined by the domain in which the communication
is occurring.
The 
.I addrlen
is a value-result parameter; it should initially contain the
amount of space pointed to by
.IR addr ;
on return it will contain the actual length (in bytes) of the
address returned.
This call
is used with connection-based socket types, currently with SOCK_STREAM.
.PP
It is possible to
.IR select (2)
a socket for the purposes of doing an
.I accept
by selecting it for read.
.SH "RETURN VALUE
The call returns \-1 on error.  If it succeeds, it returns a non-negative
integer that is a descriptor for the accepted socket.
.SH ERRORS
The \fIaccept\fP will fail if:
.TP 20
[EBADF]
The descriptor is invalid.
.TP 20
[ENOTSOCK]
The descriptor references a file, not a socket.
.TP 20
[EOPNOTSUPP]
The referenced socket is not of type SOCK_STREAM.
.TP 20
[EFAULT]
The \fIaddr\fP parameter is not in a writable part of the
user address space.
.TP 20
[EWOULDBLOCK]
The socket is marked non-blocking and no connections
are present to be accepted.
.SH SEE ALSO
bind(2), connect(2), listen(2), select(2), socket(2)
