.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)telnetd.8c	6.3 (Berkeley) 5/28/86
.\"
.TH TELNETD 8C "May 28, 1986"
.UC 5
.SH NAME
telnetd \- DARPA TELNET protocol server
.SH SYNOPSIS
.B /etc/telnetd
.SH DESCRIPTION
.I Telnetd
is a server which supports the DARPA standard
.B TELNET
virtual terminal protocol.
.I Telnetd
is invoked by the internet server (see
.IR inetd (8)),
normally for requests to connect to the
.B TELNET
port as indicated by the
.I /etc/services
file (see
.IR services (5)).
.PP
.I Telnetd
operates by allocating a pseudo-terminal device (see
.IR pty (4))
for a client, then creating a login process which has
the slave side of the pseudo-terminal as 
.BR stdin ,
.BR stdout ,
and
.BR stderr .
.I Telnetd
manipulates the master side of the pseudo-terminal,
implementing the
.B TELNET
protocol and passing characters
between the remote client and the login process.
.PP
When a
.B TELNET
session is started up, 
.I telnetd
sends
.B TELNET
options to the client side indicating
a willingness to do
.I remote echo
of characters, to
.I suppress go
.IR ahead ,
and to receive
.I terminal type information
from the remote client.
If the remote client is willing, the remote terminal type is
propagated in the environment of the created login process.
The pseudo-terminal allocated to the client is configured
to operate in \*(lqcooked\*(rq mode, and with XTABS and CRMOD
enabled (see
.IR tty (4)).
.PP
.I Telnetd
is willing to
.IR do :
.IR echo ,
.IR binary ,
.I suppress go
.IR ahead ,
and
.I timing
.IR mark .
.I Telnetd
is willing to have the remote client
.IR do :
.IR binary ,
.I terminal
.IR type ,
and
.I suppress go
.IR ahead .
.SH "SEE ALSO"
telnet(1C)
.SH BUGS
Some
.B TELNET
commands are only partially implemented.
.PP
The
.B TELNET
protocol allows for
the exchange of the number of lines and columns on the user's terminal,
but
.I telnetd
doesn't make use of them.
.PP
Because of bugs in the original 4.2 BSD
.IR telnet (1C),
.I telnetd
performs some dubious protocol exchanges to try to discover if the remote
client is, in fact, a 4.2 BSD
.IR telnet (1C).
.PP
.I Binary mode
has no common interpretation except between similar operating systems
(Unix in this case).
.PP
The terminal type name received from the remote client is converted to
lower case.
.PP
The
.I packet
interface to the pseudo-terminal
(see
.IR pty (4))
should be used for more
intelligent flushing of input and output queues.
.PP
.I Telnetd
never sends
.B TELNET
.I go ahead
commands.
