.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)shutdown.8	6.4 (Berkeley) 5/26/86
.\"
.TH SHUTDOWN 8 "May 26, 1986"
.UC 4
.SH NAME
shutdown \- close down the system at a given time
.SH SYNOPSIS
.B /etc/shutdown
[
.B \-k
] [
.B \-r
] [
.B \-h
] [
.B \-f
] [
.B \-n
]
time [ warning-message ... ]
.SH DESCRIPTION
.I Shutdown
provides an automated shutdown procedure which a super-user
can use to notify users
nicely when the system is shutting down, saving them from
system administrators, hackers, and gurus, who would otherwise
not bother with niceties.
.LP
.I Time
is the time at which
.I shutdown
will bring the system down and
may be the word
.B now
(indicating an immediate shutdown)
or specify a future time in one of two formats:
.BR + number
and
.RB hour : min.
The first form brings the system down in
.I number
minutes
and the second brings the system down at the time of day indicated
(as a 24\-hour clock).
.PP
At intervals which get closer together as apocalypse approaches,
warning messages are displayed at the terminals of all users on the
system.  Five minutes before shutdown, or immediately if
shutdown is in less than 5 minutes, logins are disabled by
creating
/etc/nologin
and writing a message there.
If this file exists when a user attempts to log in,
.IR login (1)
prints its contents
and exits.
The file is removed just before
.I shutdown
exits.
.PP
At shutdown time a
message is written in the system log, containing the
time of shutdown, who ran shutdown and the reason.
Then a terminate signal is sent to
.I init
to bring the system down to single-user state.
Alternatively, if
.B \-r,
.B \-h,
or
.B \-k
was used, then
.I shutdown
will exec
.IR reboot (8),
.IR halt (8),
or avoid shutting the system down (respectively).
(If it isn't obvious,
.B \-k
is to make people
.I think
the system is going down!)
.PP
With the
.B \-f
option,
.I shutdown
arranges, in the manner of
.IR fastboot (8),
that when the system is rebooted the file systems will not
be checked.  The
.B \-n
option prevents the normal
.IR sync (2)
before stopping.
.PP
The time of the shutdown and the warning message
are placed in /etc/nologin and should be used to
inform the users about when the system will be back up
and why it is going down (or anything else).
.SH FILES
.DT
/etc/nologin	tells login not to let anyone log in
.SH "SEE ALSO"
login(1), reboot(8), fastboot(8)
.SH BUGS
Only allows you to kill the system between now and 23:59 if
you use the absolute time for shutdown.
