.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rshd.8	6.4 (Berkeley) 10/25/87
.\"
.TH RSHD 8C "October 25, 1987"
.UC 5
.SH NAME
rshd \- remote shell server
.SH SYNOPSIS
.B /etc/rshd
.SH DESCRIPTION
.I Rshd
is the server for the 
.IR rcmd (3X)
routine and, consequently, for the
.IR rsh (1C)
program.  The server provides remote execution facilities
with authentication based on privileged port numbers from trusted hosts.
.PP
.I Rshd
listens for service requests at the port indicated in
the ``cmd'' service specification; see
.IR services (5).
When a service request is received the following protocol
is initiated:
.IP 1)
The server checks the client's source port.
If the port is not in the range 0-1023, the server
aborts the connection.
.IP 2)
The server reads characters from the socket up
to a null (`\e0') byte.  The resultant string is
interpreted as an ASCII number, base 10.
.IP 3)
If the number received in step 2 is non-zero,
it is interpreted as the port number of a secondary
stream to be used for the 
.BR stderr .
A second connection is then created to the specified
port on the client's machine.  The source port of this
second connection is also in the range 0-1023.
.IP 4)
The server checks the client's source address
and requests the corresponding host name (see
.IR gethostbyaddr (3N),
.IR hosts (5)
and
.IR named (8)).
If the hostname cannot be determined,
the dot-notation representation of the host address is used.
.IP 5)
A null terminated user name of at most 16 characters
is retrieved on the initial socket.  This user name
is interpreted as the user identity on the
.BR client 's
machine.
.IP 6)
A null terminated user name of at most 16 characters
is retrieved on the initial socket.  This user name
is interpreted as a user identity to use on the
.BR server 's
machine.
.IP 7)
A null terminated command to be passed to a
shell is retrieved on the initial socket.  The length of
the command is limited by the upper bound on the size of
the system's argument list.  
.IP 8)
.I Rshd
then validates the user according to the following steps.
The local (server-end) user name is looked up in the password file
and a
.I chdir
is performed to the user's home directory.  If either
the lookup or 
.I chdir
fail, the connection is terminated.
If the user is not the super-user, (user id 0), the file 
.I /etc/hosts.equiv
is consulted for a list of hosts considered ``equivalent''.
If the client's host name is present in this file, the
authentication is considered successful.  If the lookup
fails, or the user is the super-user, then the file
.I .rhosts
in the home directory of the remote user is checked for
the machine name and identity of the user on the client's
machine.  If this lookup fails, the connection is terminated.
.IP 9)
A null byte is returned on the initial socket
and the command line is passed to the normal login
shell of the user.  The
shell inherits the network connections established
by
.IR rshd .
.SH DIAGNOSTICS
Except for the last one listed below,
all diagnostic messages
are returned on the initial socket,
after which any network connections are closed.
An error is indicated by a leading byte with a value of
1 (0 is returned in step 9 above upon successful completion
of all the steps prior to the execution of the login shell).
.PP
.B ``locuser too long''
.br
The name of the user on the client's machine is
longer than 16 characters.
.PP
.B ``remuser too long''
.br
The name of the user on the remote machine is
longer than 16 characters.
.PP
.B ``command too long ''
.br
The command line passed exceeds the size of the argument
list (as configured into the system).
.PP
.B ``Login incorrect.''
.br
No password file entry for the user name existed.
.PP
.B ``No remote directory.''
.br
The 
.I chdir
command to the home directory failed.
.PP
.B ``Permission denied.''
.br
The authentication procedure described above failed.
.PP
.B ``Can't make pipe.''
.br
The pipe needed for the 
.BR stderr ,
wasn't created.
.PP
.B ``Try again.''
.br
A
.I fork
by the server failed.
.PP
.B ``<shellname>: ...''
.br
The user's login shell could not be started.  This message is returned
on the connection associated with the
.BR stderr ,
and is not preceded by a flag byte.
.SH SEE ALSO
rsh(1C),
rcmd(3X)
.SH BUGS
The authentication procedure used here assumes the integrity
of each client machine and the connecting medium.  This is
insecure, but is useful in an ``open'' environment.
.PP
A facility to allow all data exchanges to be encrypted should be
present.
.PP
A more extensible protocol should be used.
