.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)routed.8c	6.3 (Berkeley) 2/10/87
.\"
.TH ROUTED 8C "February 10, 1987"
.UC 5
.SH NAME
routed \- network routing daemon
.SH SYNOPSIS
.B /etc/routed
[
.B \-d
] [
.B \-g
] [
.B \-s
] [
.B \-q
] [
.B \-t
] [
.I logfile
]
.SH DESCRIPTION
.I Routed
is invoked at boot time to manage the network routing tables.
The routing daemon uses a variant of the Xerox NS Routing
Information Protocol in maintaining up to date kernel routing
table entries.
It used a generalized protocol capable of use with multiple
address types, but is currently used only for Internet routing
within a cluster of networks.
.PP
In normal operation
.I routed
listens on the
.IR udp (4P)
socket for the
.I route
service (see
.IR services (5))
for routing information packets.  If the host is an
internetwork router, it periodically supplies copies
of its routing tables to any directly connected hosts
and networks.
.PP
When
.I routed
is started, it uses the SIOCGIFCONF
.I ioctl
to find those
directly connected interfaces configured into the
system and marked ``up'' (the software loopback interface
is ignored).  If multiple interfaces
are present, it is assumed that the host will forward packets
between networks.
.I Routed
then transmits a 
.I request
packet on each interface (using a broadcast packet if
the interface supports it) and enters a loop, listening
for
.I request
and
.I response
packets from other hosts.
.PP
When a
.I request
packet is received, 
.I routed
formulates a reply based on the information maintained in its
internal tables.  The
.I response
packet generated contains a list of known routes, each marked
with a ``hop count'' metric (a count of 16, or greater, is
considered ``infinite'').  The metric associated with each
route returned provides a metric
.IR "relative to the sender" .
.PP
.I Response
packets received by
.I routed
are used to update the routing tables if one of the following
conditions is satisfied:
.TP
(1)
No routing table entry exists for the destination network
or host, and the metric indicates the destination is ``reachable''
(i.e. the hop count is not infinite).
.TP
(2)
The source host of the packet is the same as the router in the
existing routing table entry.  That is, updated information is
being received from the very internetwork router through which
packets for the destination are being routed.
.TP
(3)
The existing entry in the routing table has not been updated for
some time (defined to be 90 seconds) and the route is at least
as cost effective as the current route.
.TP
(4)
The new route describes a shorter route to the destination than
the one currently stored in the routing tables; the metric of
the new route is compared against the one stored in the table
to decide this.
.PP
When an update is applied,
.I routed
records the change in its internal tables and updates the kernel
routing table.
The change is reflected in the next
.I response
packet sent.
.PP
In addition to processing incoming packets,
.I routed
also periodically checks the routing table entries.
If an entry has not been updated for 3 minutes, the entry's metric
is set to infinity and marked for deletion.  Deletions are delayed
an additional 60 seconds to insure the invalidation is propagated
throughout the local internet.
.PP
Hosts acting as internetwork routers gratuitously supply their
routing tables every 30 seconds to all directly connected hosts
and networks.
The response is sent to the broadcast address on nets capable of that function,
to the destination address on point-to-point links, and to the router's
own address on other networks.
The normal routing tables are bypassed when sending gratuitous responses.
The reception of responses on each network is used to determine that the
network and interface are functioning correctly.
If no response is received on an interface, another route may be chosen
to route around the interface, or the route may be dropped if no alternative
is available.
.PP
.I Routed supports several options:
.TP
.B \-d
Enable additional debugging information to be logged,
such as bad packets received.
.TP
.B \-g
This flag is used on internetwork routers to offer a route
to the ``default'' destination.
This is typically used on a gateway to the Internet,
or on a gateway that uses another routing protocol whose routes
are not reported to other local routers.
.TP
.B \-s
Supplying this
option forces 
.I routed
to supply routing information whether it is acting as an internetwork
router or not.
This is the default if multiple network interfaces are present,
or if a point-to-point link is in use.
.TP
.B \-q
This
is the opposite of the
.B \-s
option.
.TP
.B \-t
If the
.B \-t
option is specified, all packets sent or received are
printed on the standard output.  In addition,
.I routed
will not divorce itself from the controlling terminal
so that interrupts from the keyboard will kill the process.
.PP
Any other argument supplied is interpreted as the name
of file in which 
.IR routed 's
actions should be logged.  This log contains information
about any changes to the routing tables and, if not tracing all packets,
a history of recent messages sent and received which are related to
the changed route.
.PP
In addition to the facilities described above, 
.I routed
supports the notion of ``distant''
.I passive
and 
.I active
gateways.  When 
.I routed
is started up, it reads the file
.I /etc/gateways
to find gateways which may not be located using
only information from the SIOGIFCONF
.IR ioctl .
Gateways specified in this manner should be marked passive
if they are not expected to exchange routing information,
while gateways marked active
should be willing to exchange routing information (i.e.
they should have a
.I routed
process running on the machine).
Routes through passive gateways are installed in the
kernel's routing tables once upon startup.
Such routes are not included in
any routing information transmitted.
Active gateways are treated equally to network
interfaces.  Routing information is distributed
to the gateway and if no routing information is
received for a period of the time, the associated
route is deleted.
Gateways marked
.I external
are also passive, but are not placed in the kernel
routing table nor are they included in routing updates.
The function of external entries is to inform
.I routed
that another routing process
will install such a route, and that alternate routes to that destination
should not be installed.
Such entries are only required when both routers may learn of routes
to the same destination.
.PP
The 
.I /etc/gateways
is comprised of a series of lines, each in
the following format:
.PP
.nf
< \fBnet\fP | \fBhost\fP > \fIname1\fP \fBgateway\fP \fIname2\fP \fBmetric\fP \fIvalue\fP < \fBpassive\fP | \fBactive\fP | \fBexternal\fP >
.fi
.PP
The 
.B net
or
.B host
keyword indicates if the route is to a network or specific host.
.PP
.I Name1
is the name of the destination network or host.  This may be a
symbolic name located in
.I /etc/networks
or
.I /etc/hosts
(or, if started after
.IR named (8),
known to the name server), 
or an Internet address specified in ``dot'' notation; see
.IR inet (3N).
.PP
.I Name2
is the name or address of the gateway to which messages should
be forwarded.
.PP
.I Value
is a metric indicating the hop count to the destination host
or network.
.PP
One of the keywords
.BR passive ,
.B active
or
.B external
indicates if the gateway should be treated as 
.I passive
or
.I active
(as described above),
or whether the gateway is
.I external
to the scope of the
.I routed
protocol.
.PP
Internetwork routers that are directly attached to the Arpanet or Milnet
should use the Exterior Gateway Protocol (EGP) to gather routing information
rather then using a static routing table of passive gateways.
EGP is required in order to provide routes for local networks to the rest
of the Internet system.
Sites needing assistance with such configurations
should contact the Computer Systems Research Group at Berkeley.
.SH FILES
.DT
/etc/gateways	for distant gateways
.SH "SEE ALSO"
``Internet Transport Protocols'', XSIS 028112, Xerox System Integration
Standard.
.br
udp(4P), icmp(4P), XNSrouted(8C), htable(8)
.SH BUGS
The kernel's routing tables may not correspond to those of
.I routed
when redirects change or add routes.
.I Routed
should note any redirects received by reading
the ICMP packets received via a raw socket.
.PP
.I Routed
should incorporate other routing protocols,
such as Xerox NS
.RI ( XNSrouted (8C))
and EGP.
Using separate processes for each requires configuration options
to avoid redundant or competing routes.
.PP
.I Routed
should listen to intelligent interfaces, such as an IMP,
to gather more information.
It does not always detect unidirectional failures in network interfaces
(e.g., when the output side fails).
