.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)route.8c	6.2 (Berkeley) 5/24/86
.\"
.TH ROUTE 8C "May 24, 1986"
.UC 5
.SH NAME
route \- manually manipulate the routing tables
.SH SYNOPSIS
.B /etc/route
[
.B \-f
] [
.B \-n
] [
.I command args
]
.SH DESCRIPTION
.I Route
is a program used to manually manipulate the network
routing tables.  It normally is not needed, as the
system routing table management daemon,
.IR routed (8C),
should tend to this task.
.PP
.I Route
accepts two commands:
.IR add ,
to add a route, and
.IR delete ,
to delete a route.
.PP
All commands have the following syntax:
.PP
.ti +0.25i
.B /etc/route 
.I command
[
.B net
|
.B host
]
.I destination gateway
[
.I metric
]
.PP
where
.I destination
is the destination host or network,
.I gateway
is the next-hop gateway to which packets should be addressed, and
.I metric
is a count indicating the number of hops to
the
.IR destination .
The metric is required for
.I add
commands; it must be zero if the destination is on a directly-attached network,
and nonzero if the route utilizes one or more gateways.
If adding a route with metric 0,
the gateway given is the address of this host on the common network,
indicating the interface to be used for transmission.
Routes to a particular host are distinguished from those to
a network by interpreting the Internet address associated with
.IR destination .
The optional keywords
.B net
and
.B host
force the destination to be interpreted as a network or a host, respectively.
Otherwise, if the 
.I destination
has a ``local address part'' of INADDR_ANY,
or if the
.I destination
is the symbolic name of a network, then the route is
assumed to be to a network; otherwise, it is presumed to be a
route to a host.  If the route is to a destination connected
via a gateway, the 
.I metric
should be greater than 0.  All symbolic names specified for a
.I destination 
or 
.I gateway
are looked up first as a host name using
.IR gethostbyname (3N).
If this lookup fails,
.IR getnetbyname (3N)
is then used to interpret the name as that of a network.
.PP
.I Route
uses a raw socket and the SIOCADDRT and SIOCDELRT
.IR ioctl 's
to do its work.  As such, only the super-user may modify
the routing tables.
.PP
If the 
.B \-f
option is specified, 
.I route
will ``flush'' the routing tables of all gateway entries.
If this is used in conjunction with one of the commands
described above, the tables are flushed prior to the command's
application.
.PP
The
.B \-n
option prevents attempts to print host and network names symbolically
when reporting actions.
.SH DIAGNOSTICS
``\fBadd [ host | network ] %s: gateway %s flags %x\fP''
.br
The specified route is being added to the tables.  The
values printed are from the routing table entry supplied
in the 
.I ioctl
call.
If the gateway address used was not the primary address of the gateway
(the first one returned by
.IR gethostbyname ),
the gateway address is printed numerically as well as symbolically.
.PP
``\fBdelete [ host | network ] %s: gateway %s flags %x\fP''
.br
As above, but when deleting an entry.
.PP
``\fB%s %s done\fP''
.br
When the 
.B \-f
flag is specified, each routing table entry deleted
is indicated with a message of this form.
.PP
``\fBNetwork is unreachable\fP''
.br
An attempt to add a route failed because the gateway listed was not
on a directly-connected network.
The next-hop gateway must be given.
.PP
``\fBnot in table\fP''
.br
A delete operation was attempted for an entry which
wasn't present in the tables.
.PP
``\fBrouting table overflow\fP''
.br
An add operation was attempted, but the system was
low on resources and was unable to allocate memory
to create the new entry.
.SH "SEE ALSO"
intro(4N),
routed(8C),
XNSrouted(8C)
