.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rmt.8c	6.1 (Berkeley) 4/27/85
.\"
.TH RMT 8C "April 27, 1985"
.UC 5
.SH NAME
rmt \- remote magtape protocol module
.SH SYNOPSIS
.B /etc/rmt
.SH DESCRIPTION
.I Rmt
is a program used by the remote dump and restore programs
in manipulating a magnetic tape drive through an interprocess
communication connection.
.I Rmt
is normally started up with an
.IR rexec (3X)
or
.IR rcmd (3X)
call.
.PP
The 
.I rmt
program accepts requests specific to the manipulation of
magnetic tapes, performs the commands, then responds with
a status indication.  All responses are in ASCII and in
one of two forms. 
Successful commands have responses of
.PP
.ti +0.5i
\fBA\fInumber\fR\en
.PP
where 
.I number
is an ASCII representation of a decimal number.
Unsuccessful commands are responded to with
.PP
.ti +0.5i
\fBE\fIerror-number\fR\en\fIerror-message\fR\en,
.PP
where
.I error-number
is one of the possible error
numbers described in
.IR intro (2)
and
.I error-message
is the corresponding error string as printed
from a call to
.IR perror (3).
The protocol is comprised of the
following commands (a space is present between each token).
.TP 15
.B O device mode
Open the specified 
.I device
using the indicated
.IR mode .
.I Device
is a full pathname and
.I mode
is an ASCII representation of a decimal
number suitable for passing to
.IR open (2).
If a device had already been opened, it is
closed before a new open is performed.
.TP 15
.B C device
Close the currently open device.  The
.I device
specified is ignored.
.TP 15
.B L whence offset
Perform an
.IR lseek (2)
operation using the specified parameters.
The response value is that returned from the
.I lseek
call.
.TP 15
.B W count
Write data onto the open device.
.I Rmt
reads
.I count
bytes from the connection, aborting if
a premature end-of-file is encountered.
The response value is that returned from
the
.IR write (2)
call.
.TP 15
.B R count
Read
.I count
bytes of data from the open device.
If
.I count
exceeds the size of the data buffer (10 kilobytes), it is
truncated to the data buffer size.
.I Rmt
then performs the requested 
.IR read (2)
and responds with 
\fBA\fIcount-read\fR\en if the read was
successful; otherwise an error in the
standard format is returned.  If the read
was successful, the data read is then sent.
.TP 15
.B I operation count 
Perform a MTIOCOP 
.IR ioctl (2)
command using the specified parameters.
The parameters are interpreted as the
ASCII representations of the decimal values
to place in the 
.I mt_op
and
.I mt_count
fields of the structure used in the
.I ioctl
call.  The return value is the
.I count
parameter when the operation is successful.
.TP 15
.B S
Return the status of the open device, as
obtained with a MTIOCGET 
.I ioctl
call.  If the operation was successful,
an ``ack'' is sent with the size of the
status buffer, then the status buffer is
sent (in binary).
.PP
Any other command causes 
.I rmt
to exit.
.SH DIAGNOSTICS
All responses are of the form described above.
.SH "SEE ALSO"
rcmd(3X),
rexec(3X),
mtio(4),
rdump(8C),
rrestore(8C)
.SH BUGS
People tempted to use this for a remote file access protocol
are discouraged.
