.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rlogind.8c	6.3 (Berkeley) 5/24/86
.\"
.TH RLOGIND 8C "May 24, 1986"
.UC 5
.SH NAME
rlogind \- remote login server
.SH SYNOPSIS
.B /etc/rlogind
[
.B \-d
]
.SH DESCRIPTION
.I Rlogind
is the server for the 
.IR rlogin (1C)
program.  The server provides a remote login facility
with authentication based on privileged port numbers from trusted hosts.
.PP
.I Rlogind
listens for service requests at the port indicated in
the ``login'' service specification; see
.IR services (5).
When a service request is received the following protocol
is initiated:
.IP 1)
The server checks the client's source port.
If the port is not in the range 0-1023, the server
aborts the connection.
.IP 2)
The server checks the client's source address
and requests the corresponding host name (see
.IR gethostbyaddr (3N),
.IR hosts (5)
and
.IR named (8)).
If the hostname cannot be determined,
the dot-notation representation of the host address is used.
.PP
Once the source port and address have been checked, 
.I rlogind
allocates a pseudo terminal (see 
.IR pty (4)),
and manipulates file descriptors so that the slave
half of the pseudo terminal becomes the 
.B stdin ,
.B stdout ,
and
.B stderr 
for a login process.
The login process is an instance of the
.IR login (1)
program, invoked with the
.B \-r
option.  The login process then proceeds with the authentication
process as described in
.IR rshd (8C),
but if automatic authentication fails, it reprompts the user
to login as one finds on a standard terminal line.
.PP
The parent of the login process manipulates the master side of
the pseduo terminal, operating as an intermediary
between the login process and the client instance of the
.I rlogin
program.  In normal operation, the packet protocol described
in
.IR pty (4)
is invoked to provide ^S/^Q type facilities and propagate
interrupt signals to the remote programs.  The login process
propagates the client terminal's baud rate and terminal type,
as found in the environment variable, ``TERM''; see
.IR environ (7).
The screen or window size of the terminal is requested from the client,
and window size changes from the client are propagated to the pseudo terminal.
.SH DIAGNOSTICS
All diagnostic messages are returned on the connection
associated with the
.BR stderr ,
after which any network connections are closed.
An error is indicated by a leading byte with a value of 1.
.PP
.B ``Try again.''
.br
A
.I fork
by the server failed.
.PP
.B ``/bin/sh: ...''
.br
The user's login shell could not be started.
.SH BUGS
The authentication procedure used here assumes the integrity
of each client machine and the connecting medium.  This is
insecure, but is useful in an ``open'' environment.
.PP
A facility to allow all data exchanges to be encrypted should be
present.
.PP
A more extensible protocol should be used.
