.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)renice.8	6.2 (Berkeley) 5/19/86
.\"
.TH RENICE 8 "May 19, 1986"
.UC 4
.SH NAME
renice \- alter priority of running processes
.SH SYNOPSIS
.B /etc/renice
priority [ [
.B \-p
] pid ... ] [ [
.B \-g
] pgrp ... ] [ [
.B \-u
] user ... ]
.SH DESCRIPTION
.I Renice
alters the 
scheduling priority of one or more running processes.
The
.I who
parameters are interpreted as process ID's, process group
ID's, or user names.
.IR Renice 'ing
a process group causes all processes in the process group
to have their scheduling priority altered.  
.IR Renice 'ing
a user causes all processes owned by the user to have
their scheduling priority altered.
By default, the processes to be affected are specified by
their process ID's.  To force 
.I who
parameters to be interpreted as process group ID's, a
.B \-g 
may be specified.  To force the
.I who
parameters to be interpreted as user names, a
.B \-u
may be given.  Supplying
.B \-p
will reset 
.I who
interpretation to be (the default) process ID's.
For example,
.sp
	/etc/renice +1 987 -u daemon root -p 32 
.sp
would change the priority of process ID's 987 and 32, and
all processes owned by users daemon and root.
.PP
Users other than the super-user may only alter the priority of
processes they own,
and can only monotonically increase their ``nice value''
within the range 0 to PRIO_MAX (20).
(This prevents overriding administrative fiats.)
The super-user
may alter the priority of any process
and set the priority to any value in the range PRIO_MIN (\-20)
to PRIO_MAX.
Useful priorities are:
20 (the affected processes will run only when nothing else
in the system wants to),
0 (the ``base'' scheduling priority),
anything negative (to make things go very fast).
.SH FILES
/etc/passwd	to map user names to user ID's
.SH SEE ALSO
getpriority(2), setpriority(2)
.SH BUGS
Non super-users can not increase scheduling priorities of their own processes,
even if they were the ones that decreased the priorities in the first place.
