.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rc.8	6.1 (Berkeley) 4/27/85
.\"
.TH RC 8 "April 27, 1985"
.UC 4
.SH NAME
rc \- command script for auto-reboot and daemons
.SH SYNOPSIS
.B /etc/rc
.br
.B /etc/rc.local
.SH DESCRIPTION
.I Rc
is the command script which controls the automatic reboot and
.I rc.local
is the script holding commands which are pertinent only
to a specific site.
.PP
When an automatic reboot is in progress,
.I rc
is invoked with the argument
.I autoboot
and runs a
.I fsck
with option
.B \-p
to ``preen'' all the disks of minor inconsistencies resulting
from the last system shutdown and to check for serious inconsistencies
caused by hardware or software failure.
If this auto-check and repair succeeds, then the second part of
.I rc
is run.
.PP
The second part of
.I rc,
which is run after a auto-reboot succeeds and also if
.I rc
is invoked when a single user shell terminates (see
.IR init (8)),
starts all the daemons on the system, preserves editor files
and clears the scratch directory
.B /tmp.
.I Rc.local
is executed immediately before any other commands after a successful
.IR fsck .
Normally, the first commands placed in the
.I rc.local
file define the machine's name, using
.IR hostname (1),
and save any possible core image that might have been
generated as a result of a system crash,
.IR savecore (8).
The latter command is included in the
.I rc.local
file because the directory in which core dumps are saved
is usually site specific.
.SH SEE ALSO
init(8),
reboot(8),
savecore(8)
.SH BUGS
