.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)quotacheck.8	6.4 (Berkeley) 7/9/88
.\"
.TH QUOTACHECK 8 "July 9, 1988"
.UC 5
.SH NAME
quotacheck \- file system quota consistency checker
.SH SYNOPSIS
.B /etc/quotacheck
[
.B \-v
] [
.B \-p
]
filesystem...
.br
.B /etc/quotacheck
[
.B \-v
] [
.B \-p
]
.B \-a
.SH DESCRIPTION
.I Quotacheck
examines each file system,
builds a table of current disc usage,
and compares this table against that stored
in the disc quota file for the file system.
If any inconsistencies are detected, both the
quota file and the current system copy of the
incorrect quotas are updated (the latter only
occurs if an active file system is checked).
.PP
If the
.B \-a
flag is supplied in place of any file system
names,
.I quotacheck
will check all the file systems indicated in
.I /etc/fstab
to be read-write with disc quotas.
.PP
Normally
.I quotacheck
reports only those quotas modified.  If the
.B \-v
option is supplied,
.I quotacheck
will indicate the calculated disc quotas for each
user on a particular file system.
.PP
If the
.B \-p
flag is supplied then parallel passes will be run on
the filesystems required, using the pass numbers in
/etc/fstab in an identical fashion to
.IR fsck (8).
.PP
.I Quotacheck
expects each file system to be checked to have a
quota file named
.I quotas
in the root directory.  If none is present, 
.I quotacheck
will ignore the file system.
.PP
.I Quotacheck 
is normally run at boot time from the
.I /etc/rc.local
file, see
.IR rc (8),
before enabling disc quotas with
.IR quotaon (8).
.PP
.I Quotacheck
accesses the raw device in calculating the actual
disc usage for each user.  Thus, the file systems
checked should be quiescent while
.I quotacheck
is running.
.SH FILES
.DT
/etc/fstab	default file systems
.SH "SEE ALSO"
quota(2), setquota(2), quotaon(8), fsck(8)
