.\" Copyright (c) 1980, 1989, 1991 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"     @(#)fstab.5	6.5 (Berkeley) 5/10/91
.\"
.Dd May 10, 1991
.Dt FSTAB 5
.Os BSD 4
.Sh NAME
.Nm fstab
.Nd static information about the filesystems
.Sh SYNOPSIS
.Fd #include <fstab.h>
.Sh DESCRIPTION
The file
.Nm fstab
contains descriptive information about the various file
systems.
.Nm fstab
is only read by programs, and not written;
it is the duty of the system administrator to properly create 
and maintain this file.
Each filesystem is described on a separate line;
fields on each line are separated by tabs or spaces.
The order of records in
.Nm fstab
is important because
.Xr fsck 8 ,
.Xr mount 8 ,
and
.Xr umount 8
sequentially iterate through
.Nm fstab
doing their thing.
.Pp
The first field,
.Pq Fa fs_spec ,
describes the block special device or
remote filesystem to be mounted.
For filesystems of type
.Em ufs ,
the special file name is the block special file name, 
and not the character special file name.
If a program needs the character special file name,
the program must create it by appending a ``r'' after the
last ``/'' in the special file name.
.Pp
The second field,
.Pq Fa fs_file ,
describes the mount point for the filesystem.
For swap partitions, this field should be specified as ``none''.
.Pp
The third field,
.Pq Fa fs_vfstype ,
describes the type of the filesystem.
The system currently supports four types of filesystems:
.Bl -tag -width indent -offset indent
.It Em ufs 
a local
.Tn UNIX
filesystem
.It Em mfs 
a local memory-based
.Tn UNIX
filesystem
.It Em nfs 
a Sun Microsystems compatible ``Network File System''
.It Em swap 
a disk partition to be used for swapping
.El
.Pp
The fourth field,
.Pq Fa fs_mntops ,
describes the mount options associated with the filesystem.
It is formatted as a comma separated list of options.
It contains at least the type of mount (see
.Fa fs_type
below) plus any additional options
appropriate to the filesystem type.
.Pp
If the options ``userquota'' and/or ``groupquota'' are specified,
the filesystem is automatically processed by the
.Xr quotacheck 8
command, and user and/or group disk quotas are enabled with
.Xr quotaon 8 .
By default,
filesystem quotas are maintained in files named
.Pa quota.user
and
.Pa quota.group
which are located at the root of the associated filesystem.
These defaults may be overridden by putting an equal sign
and an alternative absolute pathname following the quota option.
Thus, if the user quota file for
.Pa /tmp
is stored in
.Pa /var/quotas/tmp.user ,
this location can be specified as:
.Bd -literal -offset indent
userquota=/var/quotas/tmp.user
.Ed
.Pp
The type of the mount is extracted from the
.Fa fs_mntops
field and stored separately in the
.Fa fs_type
field (it is not deleted from the
.Fa fs_mntops
field).
If
.Fa fs_type
is ``rw'' or ``ro'' then the filesystem whose name is given in the
.Fa fs_file
field is normally mounted read-write or read-only on the
specified special file.
If
.Fa fs_type
is ``sw'' then the special file is made available as a piece of swap
space by the
.Xr swapon 8
command at the end of the system reboot procedure.
The fields other than
.Fa fs_spec
and
.Fa fs_type
are unused.
If
.Fa fs_type
is specified as ``xx'' the entry is ignored.
This is useful to show disk partitions which are currently unused.
.Pp
The fifth field,
.Pq Fa fs_freq ,
is used for these filesystems by the
.Xr dump 8
command to determine which filesystems need to be dumped.
If the fifth field is not present, a value of zero is returned and
.Xr dump
will assume that the filesystem does not need to be dumped.
.Pp
The sixth field,
.Pq Fa fs_passno ,
is used by the
.Xr fsck 8
program to determine the order in which filesystem checks are done
at reboot time.
The root filesystem should be specified with a
.Fa fs_passno
of 1, and other filesystems should have a 
.Fa fs_passno
of 2.
Filesystems within a drive will be checked sequentially,
but filesystems on different drives will be checked at the
same time to utilize parallelism available in the hardware.
If the sixth field is not present or zero,
a value of zero is returned and
.Xr fsck
will assume that the filesystem does not need to be checked.
.Bd -literal
#define	FSTAB_RW	"rw"	/* read-write device */
#define	FSTAB_RO	"ro"	/* read-only device */
#define	FSTAB_SW	"sw"	/* swap device */
#define	FSTAB_XX	"xx"	/* ignore totally */

struct fstab {
	char	*fs_spec;	/* block special device name */
	char	*fs_file;	/* filesystem path prefix */
	char	*fs_vfstype;	/* type of filesystem */
	char	*fs_mntops;	/* comma separated mount options */
	char	*fs_type;	/* rw, ro, sw, or xx */
	int	fs_freq;	/* dump frequency, in days */
	int	fs_passno;	/* pass number on parallel dump */
};
.Ed
.Pp
The proper way to read records from
.Pa fstab
is to use the routines
.Xr getfsent 3 ,
.Xr getfsspec 3 ,
.Xr getfstype 3 ,
and
.Xr getfsfile 3 .
.Sh FILES
.Bl -tag -width /etc/fstab -compact
.It Pa /etc/fstab
The file
.Nm fstab
resides in
.Pa /etc .
.El
.Sh SEE ALSO
.Xr getfsent 3
.Sh HISTORY
The
.Nm
file format appeared in
.Bx 4.0 .
