.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)halt.8	6.2 (Berkeley) 5/24/86
.\"
.TH HALT 8 "May 24, 1986"
.UC 4
.SH NAME
halt \- stop the processor
.SH SYNOPSIS
.B /etc/halt
[
.B \-n
]
[
.B \-q
]
[
.B \-y
]
.SH DESCRIPTION
.I Halt
writes out sandbagged information to the disks and then stops
the processor.  The machine does not reboot, even if the auto-reboot
switch is set on the console.
.PP
The
.B \-n
option prevents the sync before stopping.  The
.B \-q
option causes a quick halt, no graceful shutdown is attempted.  The
.B \-y
option is needed if you are trying to halt the system from a dialup.
.PP
.I Halt
normally logs the shutdown using
.IR syslog (8)
and places a shutdown record in the login accounting file
/usr/adm/wtmp.
These actions are inhibited if the
.B \-n
or
.B \-q
options are present.
.SH SEE ALSO
reboot(8), shutdown(8), syslogd(8)
.SH BUGS
It is very difficult to halt a VAX, as the machine wants to then
reboot itself.  A rather tight loop suffices.
