.\" Copyright (c) 1985 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ftpd.8c	6.4 (Berkeley) 5/28/86
.\"
.TH FTPD 8C "April 27, 1985"
.UC 5
.SH NAME
ftpd \- DARPA Internet File Transfer Protocol server
.SH SYNOPSIS
.B /etc/ftpd
[
.B \-d
] [
.B \-l
] [
.BR \-t timeout
]
.SH DESCRIPTION
.I Ftpd
is the DARPA Internet File Transfer Prototocol
server process.  The server uses the TCP protocol
and listens at the port specified in the ``ftp''
service specification; see
.IR services (5).
.PP
If the 
.B \-d
option is specified,
debugging information is written to the syslog.
.PP
If the
.B \-l
option is specified,
each ftp session is logged in the syslog.
.PP
The ftp server
will timeout an inactive session after 15 minutes.
If the
.B \-t
option is specified,
the inactivity timeout period will be set to
.IR timeout .
.PP
The ftp server currently supports the following ftp
requests;  case is not distinguished.
.PP
.nf
.ta \w'Request        'u
\fBRequest	Description\fP
ABOR	abort previous command
ACCT	specify account (ignored)
ALLO	allocate storage (vacuously)
APPE	append to a file
CDUP	change to parent of current working directory
CWD	change working directory
DELE	delete a file
HELP	give help information
LIST	give list files in a directory (``ls -lg'')
MKD	make a directory
MODE	specify data transfer \fImode\fP
NLST	give name list of files in directory (``ls'')
NOOP	do nothing
PASS	specify password
PASV	prepare for server-to-server transfer
PORT	specify data connection port
PWD	print the current working directory
QUIT	terminate session
RETR	retrieve a file
RMD	remove a directory
RNFR	specify rename-from file name
RNTO	specify rename-to file name
STOR	store a file
STOU	store a file with a unique name
STRU	specify data transfer \fIstructure\fP
TYPE	specify data transfer \fItype\fP
USER	specify user name
XCUP	change to parent of current working directory
XCWD	change working directory
XMKD	make a directory
XPWD	print the current working directory
XRMD	remove a directory
.fi
.PP
The remaining ftp requests specified in Internet RFC 959 are
recognized, but not implemented.
.PP
The ftp server will abort an active file transfer only when the
ABOR command is preceded by a Telnet "Interrupt Process" (IP)
signal and a Telnet "Synch" signal in the command Telnet stream,
as described in Internet RFC 959.
.PP
.I Ftpd
interprets file names according to the ``globbing''
conventions used by
.IR csh (1).
This allows users to utilize the metacharacters ``*?[]{}~''.
.PP
.I Ftpd
authenticates users according to three rules. 
.IP 1)
The user name must be in the password data base,
.IR /etc/passwd ,
and not have a null password.  In this case a password
must be provided by the client before any file operations
may be performed.
.IP 2)
The user name must not appear in the file
.IR /etc/ftpusers .
.IP 3)
The user must have a standard shell returned by 
.IR getusershell (3).
.IP 4)
If the user name is ``anonymous'' or ``ftp'', an
anonymous ftp account must be present in the password
file (user ``ftp'').  In this case the user is allowed
to log in by specifying any password (by convention this
is given as the client host's name).
.PP
In the last case, 
.I ftpd
takes special measures to restrict the client's access privileges.
The server performs a 
.IR chroot (2)
command to the home directory of the ``ftp'' user.
In order that system security is not breached, it is recommended
that the ``ftp'' subtree be constructed with care;  the following
rules are recommended.
.IP ~ftp)
Make the home directory owned by ``ftp'' and unwritable by anyone.
.IP ~ftp/bin)
Make this directory owned by the super-user and unwritable by
anyone.  The program
.IR ls (1)
must be present to support the list commands.  This
program should have mode 111.
.IP ~ftp/etc)
Make this directory owned by the super-user and unwritable by
anyone.  The files
.IR passwd (5)
and
.IR group (5)
must be present for the 
.I ls
command to work properly.  These files should be mode 444.
.IP ~ftp/pub)
Make this directory mode 777 and owned by ``ftp''.  Users
should then place files which are to be accessible via the
anonymous account in this directory.
.SH "SEE ALSO"
ftp(1C), getusershell(3), syslogd(8)
.SH BUGS
The anonymous account is inherently dangerous and should
avoided when possible.
.PP
The server must run as the super-user
to create sockets with privileged port numbers.  It maintains
an effective user id of the logged in user, reverting to
the super-user only when binding addresses to sockets.  The
possible security holes have been extensively
scrutinized, but are possibly incomplete.
