.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)fsck.8	6.4 (Berkeley) 5/5/88
.\"
.TH FSCK 8 "May 5, 1988"
.UC 4
.de us
\\$1\l'|0\(ul'
..
.SH NAME
fsck \- file system consistency check and interactive repair
.SH SYNOPSIS
.B /etc/fsck
.B \-p
[
filesystem ...
]
.br
.B /etc/fsck
[
.B \-b
block#
] [
.B \-c
] [
.B \-y
] [
.B \-n
] [
filesystem 
] ...
.SH DESCRIPTION
The first form of
.I fsck
preens a standard set of filesystems or the specified file systems.
It is normally used in the script
.B /etc/rc
during automatic reboot.
In this case
.I fsck
reads the table
.B /etc/fstab
to determine which file systems to check.
It uses the information there to inspect groups of disks in parallel taking
maximum advantage of i/o overlap to check the file systems
as quickly as possible.
Normally, the root file system will be checked on pass 1, other
``root'' (``a'' partition) file systems on pass 2, other
small file systems on separate passes (e.g. the ``d'' file systems
on pass 3 and the ``e'' file systems on pass 4), and finally
the large user file systems on the last pass, e.g. pass 5.
Only partitions in fstab that are mounted ``rw'' or ``rq''
and that have non-zero pass number are checked.
.PP
The system takes care that only a restricted class of innocuous
inconsistencies can happen unless hardware or software failures intervene.
These are limited to the following:
.IP
Unreferenced inodes
.ns
.IP
Link counts in inodes too large
.ns
.IP
Missing blocks in the free map
.ns
.IP
Blocks in the free map also in files
.ns
.IP
Counts in the super-block wrong
.PP
These are the only inconsistencies that
.I fsck
with the
.B \-p
option will correct; if it encounters other inconsistencies, it exits
with an abnormal return status and an automatic reboot will then fail.
For each corrected inconsistency one or more lines will be printed
identifying the file system on which the correction will take place,
and the nature of the correction.  After successfully correcting a file
system,
.I fsck
will print the number of files on that file system,
the number of used and free blocks,
and the percentage of fragmentation.
.PP
If sent a QUIT signal,
.I fsck
will finish the file system checks, then exit with an abnormal
return status that causes the automatic reboot to fail.
This is useful when you wish to finish the file system checks,
but do not want the machine to come up multiuser.
.PP
Without the
.B \-p
option,
.I fsck
audits and interactively repairs inconsistent conditions for file systems. 
If the file system is inconsistent the operator is prompted for concurrence
before each correction is attempted.
It should be noted that some of the corrective actions which are not
correctable under the
.B \-p
option will result in some loss of data.
The amount and severity of data lost may be determined from the diagnostic
output.
The default action for each consistency correction
is to wait for the operator to respond \fByes\fP or \fBno\fP.
If the operator does not have write permission on the file system
.I fsck
will default to a 
.BR "\-n " action.
.PP
.I Fsck
has more consistency checks than
its predecessors
.IR "check, dcheck, fcheck, " "and" " icheck"
combined.
.PP
The following flags are interpreted by
.I fsck.
.TP 6
.B \-b
Use the block specified immediately after the flag as
the super block for the file system.  Block 32 is usually
an alternate super block.
.TP 6
.B  \-y
Assume a yes response to all questions asked by 
.I fsck;
this should be used with great caution as this is a free license
to continue after essentially unlimited trouble has been encountered.
.TP 6
.B  \-n
Assume a no response to all questions asked by 
.I fsck;
do not open the file system for writing.
.TP 6
.B  \-c
If the file system is in the old (static table) format,
convert it to the new (dynamic table) format.
If the file system is in the new format,
convert it to the old format provided the old format
can support the filesystem configuration.
In interactive mode,
.I fsck
will list the direction the conversion is to be made
and ask whether the conversion should be done.
If a negative answer is given,
no further operations are done on the filesystem.
In preen mode,
the direction of the conversion is listed and done if
possible without user interaction.
Conversion in preen mode is best used when all the file systems
are being converted at once.
The format of a file system can be determined from the
first line of output from 
.IR dumpfs (8).
.PP
If no filesystems are given to 
.I fsck
then a default list of file systems is read from
the file
.BR /etc/fstab .
.PP
.ne 10
Inconsistencies checked are as follows:
.TP 6
1.
Blocks claimed by more than one inode or the free map.
.br
.br
.ns
.TP 6
2.
Blocks claimed by an inode outside the range of the file system.
.br
.br
.ns
.TP 6
3.
Incorrect link counts.
.br
.br
.ns
.TP 6
4.
Size checks:
.br
.ns
.IP "" 12
Directory size not of proper format.
.br
Partially truncated file.
.br
.br
.ns
.TP 6
5.
Bad inode format.
.br
.br
.ns
.TP 6
6.
Blocks not accounted for anywhere.
.br
.br
.ns
.TP 6
7.
Directory checks:
.br
.br
.ns
.IP "" 12
File pointing to unallocated inode.
.br
Inode number out of range.
.br
.br
.ns
.TP 6
8.
Super Block checks:
.br
.br
.ns
.IP "" 12
More blocks for inodes than there are in the file system.
.br
.br
.ns
.TP 6
9.
Bad free block map format.
.br
.br
.ns
.TP 6
10.
Total free block and/or free inode count incorrect.
.PP
Orphaned files and directories (allocated but unreferenced) are,
with the operator's concurrence, reconnected by
placing them in the 
.B lost+found
directory.
The name assigned is the inode number.
If the
.I lost+found
directory does not exist, it is created.
If there is insufficient space its size is increased.
.PP
Checking the raw device is almost always faster.
.SH FILES
.br
.ns
.TP 21
/etc/fstab
contains default list of file systems to check.
.SH DIAGNOSTICS
The diagnostics produced by 
.I fsck
are fully enumerated and explained in Appendix A of
``Fsck \- The UNIX File System Check Program'' (SMM:5).
.SH "SEE ALSO"
fstab(5),
fs(5),
fsdb(8),
newfs(8),
mkfs(8),
crash(8V),
reboot(8)
.SH BUGS
There should be some way to start a \fBfsck \-p\fR at pass \fIn\fR.
