.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)chown.8	6.3 (Berkeley) 4/21/88
.\"
.TH CHOWN 8 "April 21, 1988"
.UC 4
.SH NAME
chown \- change owner
.SH SYNOPSIS
.B chown
[
.B \-Rf
]
owner[.group] file ...
.SH DESCRIPTION
.I Chown
changes the owner of the
.I files
to
.IR owner .
The owner may be either a decimal UID or
a login name found in the password file.
An optional group may also be specified.
The group may be either a decimal GID or
a group name found in the group-ID file.
.PP
Only the super-user can change owner,
in order to simplify accounting procedures.
No errors, except for usage errors, are reported when the
.B \-f
(force) option is given.
.PP
When the
.B \-R
option is given, 
.I chown
recursively descends its directory arguments
setting the specified owner.
When symbolic links are encountered, their ownership is changed,
but they are not traversed.
.SH "SEE ALSO"
chgrp(1), chown(2)
