.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ac.8	6.1 (Berkeley) 4/27/85
.\"
.TH AC 8 "April 27, 1985"
.UC 4
.SH NAME
ac \- login accounting
.SH SYNOPSIS
.B /etc/ac
[
.B \-w
wtmp ] [
.B \-p
] [
.B \-d
] [ people ] ...
.SH DESCRIPTION
.I Ac
produces a printout giving
connect time
for each user who has logged in
during the life of the current
.I wtmp
file.
A total is also produced.
.B \-w
is used to specify an alternate
.IR wtmp ""
file.
.B \-p
prints individual totals; without this option,
only totals are printed.
.B \-d
causes a printout for each midnight to midnight
period.
Any
.I people
will limit the
printout to only the specified login names.
If no
.IR wtmp ""
file is given,
.I /usr/adm/wtmp
is used.
.PP
The accounting file
.I /usr/adm/wtmp
is maintained by
.I init
and
.I login.
Neither of these programs creates the file,
so if it does not exist
no connect-time accounting is done.
To start accounting, it should be created with length 0.
On the other hand if the file is left undisturbed it will
grow without bound, so periodically any information
desired should be collected and the file truncated.
.SH FILES
/usr/adm/wtmp
.SH "SEE ALSO"
init(8), sa(8), login(1), utmp(5).
