.\"	@(#)test.1	6.2 (Berkeley) 9/22/87
.\"
.TH TEST 1 "September 22, 1987"
.AT 3
.SH NAME
test \- condition command
.SH SYNOPSIS
.B test
expr
.SH DESCRIPTION
.I test
evaluates the expression
.IR expr ,
and if its value is true then returns zero exit status; otherwise, a
non zero exit status is returned.
.I test
returns a non zero exit if there are no arguments.
.PP
The following primitives are used to construct
.IR expr .
.TP 9n
.BR \-r " file"
true if the file exists and is readable.
.TP 
.BR \-w " file"
true if the file exists and is writable.
.TP 
.BR \-f " file"
true if the file exists and is not a directory.
.TP 
.BR \-d " file"
true if the file exists and is a directory.
.TP 
.BR \-s " file"
true if the file exists and has a size greater than zero.
.TP 
.BR \-t " [ fildes ]"
true if the open file whose file descriptor number is
.I fildes
(1 by default)
is associated with a terminal device.
.TP 
.BR \-z " s1"
true if the length of string
.I s1
is zero.
.TP 
.BR \-n " s1"
true if the length of the string
.I s1
is nonzero.
.TP 
.RB s1 " = " s2
true
if the strings
.I s1
and
.I s2
are equal.
.TP 
.RB s1 " != " s2
true
if the strings
.I s1
and
.I s2
are not equal.
.TP 
s1
true if
.I s1
is not the null string.
.TP 
.RB n1 " \-eq " n2
true if the integers
.I n1
and
.I n2
are algebraically equal.
Any of the comparisons
.BR \-ne ,
.BR \-gt ,
.BR \-ge ,
.BR \-lt ,
or
.BR \-le
may be used in place of
.BR \-eq .
.PP
These primaries may be combined with the
following operators:
.TP 
.B  !
unary negation operator
.TP 
.B  \-a
binary
.I and
operator
.TP 
.B  \-o
binary
.I or
operator
.TP 
.BR "( " "expr" " )"
parentheses for grouping.
.PP
.B \-a
has higher precedence than
.B \-o.
Notice that all the operators and flags are separate
arguments to
.IR test .
Notice also that parentheses are meaningful
to the Shell and must be escaped.
.SH "SEE ALSO"
sh(1), find(1)
