.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rmdir.1	6.1 (Berkeley) 4/29/85
.\"
.TH RMDIR 1 "April 29, 1985"
.UC 5
.SH NAME
rmdir, rm  \- remove (unlink) directories or files
.SH SYNOPSIS
.B rmdir
dir ...
.PP
.B rm
[
.B \-f
] [
.B \-r
] [
.B \-i
] [
.B \-
] file ...
.PP
.SH DESCRIPTION
.PP
.I Rmdir
removes entries for the named directories, which must be empty.
.PP
.I Rm
removes the entries for one or more files from a directory.
If an entry was the last link to the file, the file is destroyed.
Removal of a file requires write permission in its directory,
but neither read nor write permission on the file itself.
.PP
If a file has no write permission and the standard input is a terminal,
its permissions are printed and a line is read from the standard input.
If that line begins with `y' the file is deleted, otherwise the file remains.
No questions are asked and no errors are reported when the
.B \-f
(force) option is given.
.PP
If a designated file is a directory,
an error comment is printed unless the optional argument
.B \-r
has been used.  In that case,
.I rm
recursively deletes the entire contents of the specified directory,
and the directory itself.
.PP
If the
.B \-i
(interactive) option is in effect,
.I rm
asks whether to delete each file, and, under
.BR \-r ,
whether to examine each directory.
.PP
The null option
.B \-
indicates that all the arguments following it are to be treated as
file names.  This allows the specification of file names starting with
a minus.
.SH "SEE ALSO"
rm(1), unlink(2), rmdir(2)
