.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rcp.1	6.5 (Berkeley) 9/16/87
.\"
.TH RCP 1C "September 16, 1987"
.UC 5
.SH NAME
rcp \- remote file copy
.SH SYNOPSIS
.B rcp
[
.B \-p
] file1 file2
.br
.B rcp
[
.B \-p
] [
.B \-r
] file ... directory
.SH DESCRIPTION
.I Rcp
copies files between machines.  Each
.I file
or
.I directory
argument is either a remote file name of the
form ``rhost:path'', or a local file name (containing no `:' characters,
or a `/' before any `:'s).
.PP
If the
.B \-r
option
is specified and any of the source files are directories,
.I rcp
copies each subtree rooted at that name; in this case
the destination must be a directory.
.PP
By default, the mode and owner of
.I file2
are preserved if it already existed; otherwise the mode of the source file
modified by the
.IR umask (2)
on the destination host is used.
The
.B \-p
option causes
.I rcp
to attempt to preserve (duplicate) in its copies the modification
times and modes of the source files, ignoring the
.IR umask .
.PP
If
.I path
is not a full path name, it is interpreted relative to
your login directory on 
.IR rhost .
A 
.I path
on a remote host may be quoted (using \e, ", or \(aa)
so that the metacharacters are interpreted remotely.
.PP
.I Rcp
does not prompt for passwords; your current local user name
must exist on
.I rhost
and allow remote command execution via
.IR rsh (1C).
.PP
.I Rcp
handles third party copies, where neither source nor target files
are on the current machine.
Hostnames may also take the form ``rname@rhost'' to use
.I rname
rather than the current user name on the remote host.
.SH SEE ALSO
cp(1), ftp(1C), rsh(1C), rlogin(1C)
.SH BUGS
Doesn't detect all cases where the target of a copy might
be a file in cases where only a directory should be legal.
.PP
Is confused by any output generated by commands in a
\&.login, \&.profile, or \&.cshrc file on the remote host.
.PP
The destination user and hostname may have to be specified as
``rhost.rname'' when the destination machine is running the 4.2BSD
version of \fIrcp\fP.

