.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)pr.1	6.1 (Berkeley) 4/29/85
.\"
.TH PR 1 "April 29, 1985"
.UC 4
.SH NAME
pr \- print file
.SH SYNOPSIS
.B pr
[ option ] ...
[ file ] ...
.SH DESCRIPTION
.I Pr
produces a printed listing of one or more
.I files.
The output is separated into pages headed by a date,
the name of the file or a specified header, and the page number.
If there are no file arguments,
.I pr
prints its standard input.
.PP
Options apply to all following files but may be reset
between files:
.TP
.BI \- n
Produce
.IR n -column
output.
.TP
.BI + n
Begin printing with page
.I  n.
.TP
.B  \-h
Take the next argument as a page header.
.TP
.BI \-w n
For purposes of multi-column output,
take the width of the page to be
.I n
characters instead of the default 72.
.TP
.BI \-f
Use formfeeds instead of newlines to separate pages.
A formfeed is assumed to use up two blank lines at the top of a page.
(Thus this option does not affect the effective page length.)
.TP
.BI \-l n
Take the length of the page to be
.I n
lines instead of the default 66.
.TP
.B  \-t
Do not print the 5-line header or the
5-line trailer normally supplied for each page.
.TP
.BI \-s c
Separate columns by the single character
.I c
instead of by the appropriate amount of white space.
A missing
.I c
is taken to be a tab.
.TP
.B  \-m
Print all
.I files
simultaneously,
each in one column,
.PP
Inter-terminal messages via
.IR write (1)
are
forbidden during a
.IR pr .
.SH FILES
/dev/tty?
to suspend messages.
.SH "SEE ALSO"
cat(1)
.SH DIAGNOSTICS
There are no diagnostics when
.I pr
is printing on a terminal.
