.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mt.1	6.2 (Berkeley) 5/9/86
.\"
.TH MT 1 "May 9, 1986"
.UC 4
.SH NAME
mt \- magnetic tape manipulating program
.SH SYNOPSIS
.B mt
[
.B \-f
.I tapename
]
.I command
[
.I count
]
.SH DESCRIPTION
.I Mt
is used to give commands to a magnetic tape drive.
If a tape name is not specified, the environment variable
TAPE is used;  if TAPE does not exist,
.I mt
uses the device
.IR /dev/rmt12 .
Note
that
.I tapename
must reference a raw (not block) tape device.
By default
.I mt
performs the requested operation once.  Operations
may be performed multiple times by specifying
.IR count .
.PP
The available commands are listed below.  Only as many
characters as are required to uniquely identify a command
need be specified.
.TP
.BR eof , " weof"
Write 
.I count
end-of-file marks at the current position on the tape.
.TP
.B fsf
Forward space
.I count
files.
.TP
.B fsr
Forward space 
.I count
records.
.TP
.B bsf
Back space 
.I count
files.
.TP 
.B bsr
Back space
.I count
records.
.TP
.B rewind
Rewind the tape
.RI ( Count
is ignored). 
.TP
.BR offline , " rewoffl"
Rewind the tape and place the tape unit off-line
.RI ( Count
is ignored).
.TP
.B status
Print status information about the tape unit.
.PP
.I Mt
returns a 0 exit status when the operation(s) were successful,
1 if the command was unrecognized, and 2 if an operation failed.
.SH FILES
.DT
/dev/rmt*	Raw magnetic tape interface
.SH "SEE ALSO"
mtio(4), dd(1), ioctl(2), environ(7)
