.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)login.1	6.4 (Berkeley) 9/14/87
.\"
.TH LOGIN 1 "September 14, 1987"
.UC 4
.SH NAME
login \- sign on
.SH SYNOPSIS
.B login
[
.B \-p
] [ username ]
.br
.B login
[
.B \-p
] [
.B \-h
hostname
] [
.B \-f
] [
username
]
.SH DESCRIPTION
The
.I login
command
is used when a user initially
signs on.
It may also be used at any time to change
from one user to another.
This case is the one summarized first above and described here.
See \*(lqHow to Get Started\*(rq for how to connect initially.
The invocation of
.I login
for initial sign-on
is made by a system program or server using the latter form of the command
and is described below.
.PP
If
.I login
is invoked without an argument,
it asks for a user name, and, if
appropriate, a password.
Echoing is turned off (if possible) during the typing of the password,
so it will not appear on the written record of the
session.
.PP
After a successful login,
accounting files are updated and
the user is informed of the
existence of mail.
The message of the day is printed,
as is the time of his last login.
Both are suppressed if he has a \*(lq.hushlogin\*(rq
file in his home directory; this
is mostly used to make life easier for non-human users, such as
.IR uucp .
.PP
.I Login
initializes the user and group IDs and the working directory,
then executes a command interpreter (usually
.IR  csh (1))
according to specifications found in a password file.
Argument 0 of the command interpreter is
the name of the command interpreter with
a leading dash (\*(lq\-\*(rq).
.PP
Login also modifies the
environment
.IR environ (7)
with information specifying home directory, command interpreter, terminal
type (if available) and user name.
The `\-p' argument causes the remainder of the environment to be preserved,
otherwise any previous environment is discarded.
.PP
If the file /etc/nologin exists,
.I login
prints its contents on the user's terminal and exits. This is
used by
.IR shutdown (8)
to stop users logging in when the system is about to go down.
.PP
Login is recognized by
.IR sh (1)
and
.IR csh (1)
and executed directly (without forking).
.PP
There are several additional options to
.I login
for use at initial login.
With one exception, these options are available only to the superuser.
The
.B \-h
option is used by
.IR telnetd (8C)
and other servers to list the host from which
the connection was received.
The
.B \-f
option is used with a username on the command line
to indicate that proper authentication has already been done
and that no password need be requested.
This option may be used by the superuser
or by the user specified on the command line.
.SH FILES
.ta \w'/usr/spool/mail/*\ \ 'u
/etc/utmp	accounting
.br
/usr/adm/wtmp	accounting
.br
/usr/spool/mail/*	mail
.br
/etc/motd	message-of-the-day
.br
/etc/passwd	password file
.br
/etc/nologin	stops logins
.br
\&.hushlogin	makes login quieter
.SH "SEE ALSO"
mail(1), passwd(1), rlogin(1), getpass(3), passwd(5), utmp(5), environ(7),
init(8), getty(8), shutdown(8),
.SH DIAGNOSTICS
\*(lqLogin incorrect,\*(rq
if the name or the password is bad.
.br
\*(lqNo Shell\*(rq, \*(lqcannot open password file\*(rq,
\*(lqno directory\*(rq:
consult a programming counselor.
.SH BUGS
An undocumented option,
.B \-r
is used by the remote login server,
.IR rlogind (8)
to force
.I login
to enter into an initial connection protocol.
