.\"	@(#)ed.1	6.1 (Berkeley) 4/29/85
.\"
.TH ED 1 "April 29, 1985"
.AT 3
.if t .ds q \(aa
.if n .ds q '
.SH NAME
ed \- text editor
.SH SYNOPSIS
.B ed
[
.B \-
] [
.B \-x
] [ name ]
.SH DESCRIPTION
.I Ed
is the standard text editor.
.PP
If a
.I name
argument is given,
.I ed
simulates an
.I e
command (see below)\| on the named file; that is to say,
the file is read into
.I ed's
buffer so that it can be edited.
If 
.B \-x
is present, an
.I x
command is simulated first to handle an encrypted file.
The optional
.B \-
suppresses the printing
of explanatory output
and should be used
when the standard input is
an editor script.
.PP
.I Ed
operates on a copy of any file it is editing; changes made
in the copy have no effect on the file until a
.IR w ""
(write)\|
command is given.
The copy of the text being edited resides
in a temporary file called the 
.IR buffer .
.PP
Commands to
.I ed
have a simple and regular structure: zero or
more
.I addresses
followed by a single character
.I command,
possibly
followed by parameters to the command.
These addresses specify one or more lines in the buffer.
Missing addresses are supplied by default.
.PP
In general, only one command may appear on a line.
Certain commands allow the 
addition of text to the buffer.
While
.I ed
is accepting text, it is said
to be in
.I  "input mode."
In this mode, no commands are recognized;
all input is merely collected.
Input mode is left by typing a period `\fB.\fR' alone at the
beginning of a line.
.PP
.I Ed
supports a limited form of
.I "regular expression"
notation.
A regular expression specifies
a set of strings of characters.
A member of this set of strings is said to be
.I matched
by the regular expression.
In the following specification for regular expressions
the word `character' means any character but newline.
.IP 1.
Any character except a special character
matches itself.
Special characters are
the regular expression delimiter plus
.RB \e\|[\| .
and sometimes ^\|*\|$.
.IP 2.
A
.B .
matches any character.
.IP 3.
A \e followed by any character except a digit or (\|) matches that character.
.IP 4.
A nonempty string
.I s
bracketed
.RI [ \|s\| ]
(or
.RI [^ s\| ])
matches any character in (or not in)
.I s.
In 
.I s,
\e has no special meaning, and ] may only appear as
the first letter.
A substring 
.I a\-b,
with
.I a
and
.I b
in ascending ASCII order, stands for the inclusive
range of ASCII characters.
.IP 5.
A regular expression of form 1-4 followed by * matches a sequence of
0 or more matches of the regular expression.
.IP 6.
A regular expression,
.I x,
of form 1-8, bracketed
.RI \e( \|x\| \e)
matches what
.I x
matches.
.IP 7.
A \e followed by a digit 
.I n
matches a copy of the string that the
bracketed regular expression beginning with the
.IR n th
\e( matched.
.IP 8.
A regular expression of form 1-8,
.I x,
followed by a regular expression of form 1-7,
.I y
matches a match for
.I x
followed by a match for
.I y,
with the
.I x
match being as long as possible while still permitting a
.I y
match.
.IP 9.
A regular expression of form 1-8 preceded by ^
(or followed by $), is constrained to matches that
begin at the left (or end at the right) end of a line.
.IP 10.
A regular expression of form 1-9 picks out the
longest among the leftmost matches in a line.
.IP 11.
An empty regular expression stands for a copy of the
last regular expression encountered.
.PP
Regular expressions are used in addresses to specify
lines and in one command
(see
.I s
below)\|
to specify a portion of a line which is to be replaced.
If it is desired to use one of
the regular expression metacharacters as an ordinary
character, that character may be preceded by `\e'.
This also applies to the character bounding the regular
expression (often `/')\| and to `\e' itself.
.PP
To understand addressing in
.I ed
it is necessary to know that at any time there is a
.I  "current line."
Generally speaking, the current line is
the last line affected by a command; however,
the exact effect on the current line
is discussed under the description of
the command.
Addresses are constructed as follows.
.TP
1.
The character `\fB.\fR' addresses the current line.
.TP
2.
The character `$' addresses the last line of the buffer.
.TP
3.
A decimal number
.I n
addresses the
.IR n -th
line of the buffer.
.TP
4.
`\(fm\fIx\fR' addresses the line marked with the name
.IR x ,
which must be a lower-case letter.
Lines are marked with the
.I k
command described below.
.TP
5.
A regular expression enclosed in slashes `/' addresses
the line found by searching forward from the current line
and stopping at the first line containing a
string that matches the regular expression.
If necessary the search wraps around to the beginning of the
buffer.
.TP
6.
A regular expression enclosed in queries `?' addresses
the line found by searching backward from the current line
and stopping at the first line containing
a string that matches the regular expression.
If necessary
the search wraps around to the end of the buffer.
.TP
7.
An address followed by a plus sign `+'
or a minus sign `\-' followed by a decimal number specifies that address plus
(resp. minus)\| the indicated number of lines.
The plus sign may be omitted.
.TP
8.
If an address begins with `+' or `\-'
the addition or subtraction is taken with respect to the current line;
e.g. `\-5' is understood to mean `\fB.\fR\-5'.
.TP
9.
If an address ends with `+' or `\-',
then 1 is added (resp. subtracted).
As a consequence of this rule and rule 8,
the address `\-' refers to the line before the current line.
Moreover,
trailing
`+' and `\-' characters
have cumulative effect, so `\-\-' refers to the current
line less 2.
.TP
10.
To maintain compatibility with earlier versions of the editor,
the character `^' in addresses is 
equivalent to `\-'.
.PP
Commands may require zero, one, or two addresses.
Commands which require no addresses regard the presence
of an address as an error.
Commands which accept one or two addresses
assume default addresses when insufficient are given.
If more addresses are given than such a command requires,
the last one or two (depending on what is accepted)\| are used.
.PP
Addresses are separated from each other typically by a comma
`\fB,\fR'.
They may also be separated by a semicolon
`\fB;\fR'.
In this case the current line `\fB.\fR' is set to
the previous address before the next address is interpreted.
This feature can be used to determine the starting
line for forward and backward searches (`/', `?')\|.
The second address of any two-address sequence
must correspond to a line following the line corresponding to the first address.
The special form `%'
is an abbreviation for the address pair `1,$'.
.PP
In the following list of
.I ed
commands, the default addresses
are shown in parentheses.
The parentheses are not part of
the address, but are used to show that the given addresses are
the default.
.PP
As mentioned, it is generally illegal for more than one
command to appear on a line.
However, most commands may be suffixed by `p'
or by `l', in which case
the current line is either
printed or listed respectively
in the way discussed below.
Commands may also be suffixed by `n',
meaning the output of the command is to
be line numbered.
These suffixes may be combined in any order.
.TP 5
.RB (\| .\| )\|a
.br
.ns
.TP 5
<text>
.br
.ns
.TP 5
.B .
.br
The append command reads the given text
and appends it after the addressed line.
`\fB.\fR' is left
on the last line input, if there
were any, otherwise at the addressed line.
Address `0' is legal for this command; text is placed
at the beginning of the buffer.
.TP 5
.RB (\| .\| ,\  .\| )\|c
.br
.ns
.TP 5
<text>
.br
.ns
.TP 5
.B .
.br
The change
command deletes the addressed lines, then accepts input
text which replaces these lines.
`\fB.\fR' is left at the last line input; if there were none,
it is left at the line preceding the deleted lines.
.TP 5
.RB (\| .\| ,\  .\| )\|d
The delete command deletes the addressed lines from the buffer.
The line originally after the last line deleted becomes the current line;
if the lines deleted were originally at the end,
the new last line becomes the current line.
.TP 5
e filename
The edit
command causes the entire contents of the buffer to be deleted,
and then the named file to be read in.
`\fB.\fR' is set to the last line of the buffer.
The number of characters read is typed.
`filename' is remembered for possible use as a default file name
in a subsequent
.I r
or
.I w
command.
If `filename' is missing, the remembered name is used.
.TP 5
E filename
This command is the same as
.I e,
except that no diagnostic results when no
.I w
has been given since the last buffer alteration.
.TP 5
f filename
The filename command prints the currently remembered file name.
If `filename' is given,
the currently remembered file name is changed to `filename'.
.TP 5
(1,$)\|g/regular expression/command list
In the global
command, the first step is to mark every line which matches
the given regular expression.
Then for every such line, the
given command list is executed with `\fB.\fR' initially set to that line.
A single command or the first of multiple commands
appears on the same line with the global command.
All lines of a multi-line list except the last line must be ended with `\e'.
.I A,
.I i,
and
.I c
commands and associated input are permitted;
the `\fB.\fR' terminating input mode may be omitted if it would be on the
last line of the command list.
The commands
.I g
and
.I v
are not permitted in the command list.
.TP 5
.RB (\| .\| )\|i
.ns
.TP 5
<text>
.br
.ns
.TP 5
.B .
.br
This command inserts the given text before the addressed line.
`\fB.\fR' is left at the last line input, or, if there were none,
at the line before the addressed line.
This command differs from the
.I a
command only in the placement of the
text.
.TP 5
.RB (\| .\| ,\  . +1)\|j
This command joins the addressed lines into a single line;
intermediate newlines simply disappear.
`\fB.\fR' is left at the resulting line.
.TP 5
( \fB. \fR)\|k\fIx\fR
The mark command marks the addressed line with
name
.I x,
which must be a lower-case letter.
The address form `\(fm\fIx\fR' then addresses this line.
.ne 2.5
.TP 5
.RB (\| .\| ,\  .\| )\|l
The list command
prints the addressed lines in an unambiguous way:
non-graphic characters are
printed in two-digit octal,
and long lines are folded.
The
.I l
command may be placed on the same line after any non-i/o
command.
.TP 5
.RB (\| .\| ,\  .\| )\|m\fIa
The move command repositions the addressed lines after the line
addressed by
.IR a .
The last of the moved lines becomes the current line.
.TP 5
.RB (\| .\| ,\  .\| )\|p
The print command prints the addressed lines.
`\fB.\fR'
is left at the last line printed.
The
.I p
command
may
be placed on the same line after any non-i/o command.
.TP
.RB (\| .\| ,\  .\| )\|P
This command is a synonym for
.I p.
.TP 5
q
The quit command causes
.I ed
to exit.
No automatic write
of a file is done.
.TP 5
Q
This command is the same as
.I q,
except that no diagnostic results when no
.I w
has been given since the last buffer alteration.
.TP 5
($)\|r filename
The read command
reads in the given file after the addressed line.
If no file name is given,
the remembered file name, if any, is used
(see
.I e
and
.I f
commands)\|.
The file name is remembered if there was no
remembered file name already.
Address `0' is legal for
.I r
and causes the
file to be read at the beginning of the buffer.
If the read is successful, the number of characters
read is typed.
`\fB.\fR' is left at the last line read in from the file.
.TP 5
(\| \fB.\fR\|, \fB.\fR\|)\|s/regular expression/replacement/       or,
.br
.ns
.TP 5
(\| \fB.\fR\|, \fB.\fR\|)\|s/regular expression/replacement/g
The substitute command searches each addressed
line for an occurrence of the specified regular expression.
On each line in which a match is found,
all matched strings are replaced by the replacement specified,
if the global replacement indicator `g' appears after the command.
If the global indicator does not appear, only the first occurrence
of the matched string is replaced.
It is an error for the substitution to fail on all addressed lines.
Any punctuation character
may be used instead of `/' to delimit the regular expression
and the replacement.
`\fB.\fR' is left at the last line substituted.
.IP
An ampersand `&' appearing in the replacement
is replaced by the string matching the regular expression.
The special meaning of `&' in this context may be
suppressed by preceding it by `\e'.
The characters
.I `\|\en'
where
.I n
is a digit,
are replaced by the text matched by the
.IR n -th
regular subexpression
enclosed between `\e(' and `\e)'.
When
nested, parenthesized subexpressions
are present,
.I n
is determined by counting occurrences of `\e(' starting from the left.
.IP
Lines may be split by substituting new-line characters into them.
The new-line in the
replacement string
must be escaped by preceding it by `\e'.
.IP
One or two trailing delimiters may be omitted,
implying the `p' suffix.
The special form `s' followed by
.I no
delimiters
repeats the most recent substitute command
on the addressed lines.
The `s' may be followed by the letters
.B r
(use the most recent regular expression for the
left hand side, instead of the most recent
left hand side of a substitute command),
.B p
(complement the setting of the
.I p
suffix from the previous substitution), or
.B g
(complement the setting of the
.I g
suffix).
These letters may be combined in any order.
.TP 5
.RB (\| .\| ,\  .\| )\|t\|\fIa
This command acts just like the
.I m
command, except that a copy of the addressed lines is placed
after address
.I a
(which may be 0).
`\fB.\fR' is left on the last line of the copy.
.TP 5
.RB (\| .\| ,\  .\| )\|u
The undo command restores the buffer to it's state
before the most recent buffer modifying command.
The current line is also restored.
Buffer modifying commands are
.I a, c, d, g, i, k, m, r, s, t,
and
.I v.
For purposes of undo,
.I g
and
.I v
are considered to be a single buffer modifying command.
Undo is its own inverse.
.IP
When
.I ed
runs out of memory
(at about 8000 lines on any 16 bit mini-computer
such as the PDP-11)
This full undo is not possible, and
.I u
can only undo the effect of the most recent
substitute on the current line.
This restricted undo also applies to editor scripts
when
.I ed
is invoked with the
.B -
option.
.TP 5
(1, $)\|v/regular expression/command list
This command is the same as the global command
.I g
except that the command list is executed
.I g
with `\fB.\fR' initially set to every line
.I except
those
matching the regular expression.
.TP 5
(1, $)\|w filename
.br
The write command writes the addressed lines onto
the given file.
If the file does not exist,
it is created.
The file name is remembered if there was no 
remembered file name already.
If no file name is given,
the remembered file name, if any, is used
(see
.I e
and
.I f
commands)\|.
`\fB.\fR' is unchanged.
If the command is successful, the number of characters written is
printed.
.TP
(1, $)\|W filename
This command is the same as
.I w,
except that the addressed lines are appended to the file.
.TP 5
(1, $)\|wq filename
This command is the same as
.I w
except that afterwards a
.I q
command is done,
exiting the editor
after the file is written.
.TP 5
x
A key string is demanded from the standard input.
Later
.I r, e
and
.I w
commands will encrypt and decrypt the text 
with this key by the algorithm of 
.IR crypt (1).
An explicitly empty key turns off encryption.
.RB (\| .\| +1)\|z	or,
.br
.ns
.TP 5
.RB (\| .\| +1)\|z\fIn
This command scrolls through the buffer starting at the addressed line.
22 (or
.I n,
if given)
lines are printed.
The last line printed becomes the current line.
The value
.I n
is sticky, in that it becomes the default for
future
.I z
commands.
.TP 5
($)\|=
The line number of the addressed line is typed.
`\fB.\fR' is unchanged by this command.
.TP 5
!<shell command>
The remainder of the line after the `!' is sent
to
.IR sh (1)
to be interpreted as a command.
.RB ` . '
is unchanged.
.TP 5
.RB (\| . +1,\| . +1)\|<newline>
An address alone on a line causes the addressed line to be printed.
A blank line alone is equivalent to `.+1p'; it is useful
for stepping through text.
If two addresses are present with no
intervening semicolon,
.I ed
prints the range of lines.
If they are separated by a semicolon,
the second line is printed.
.PP
If an interrupt signal (ASCII DEL)\| is sent,
.I ed
prints `?interrupted'
and returns to its command level.
.PP
Some size limitations:
512 characters per line,
256 characters per global command list,
64 characters per file name,
and, on mini computers,
128K characters in the temporary file.
The limit on the number of lines depends on the amount of core:
each line takes 2 words.
.PP
When reading a file,
.I ed
discards ASCII NUL characters
and all characters after the last newline.
It refuses to read files containing non-ASCII characters.
.SH FILES
/tmp/e*
.br
edhup: work is saved here if terminal hangs up
.SH "SEE ALSO"
B. W. Kernighan,
.I
A Tutorial Introduction to the ED Text Editor
.br
B. W. Kernighan,
.I Advanced editing on UNIX
.br
ex(1), sed(1), crypt(1)
.SH DIAGNOSTICS
`?name' for inaccessible file;
`?self-explanatory message'
for other errors.
.PP
To protect against throwing away valuable work,
a
.I q
or
.I e
command is considered to be in error, unless a
.I w
has occurred since the last buffer change.
A second
.I q
or
.I e
will be obeyed regardless.
.SH BUGS
The 
.I l
command mishandles DEL.
.br
The
.I undo
command causes marks to be lost on affected lines.
.br
The
.I x
command,
.B -x
option,
and
special treatment of hangups
only work on UNIX.
