.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)date.1	6.6 (Berkeley) 4/1/87
.\"
.TH DATE 1 "April 1, 1987"
.UC 4
.SH NAME
date \- print and set the date
.SH SYNOPSIS
.B date
.RB "[-nu] [-d dst] [-t minutes_west] [yymmddhhmm [" . "ss] ]"
.SH DESCRIPTION
If no arguments are given, the current date and time are
printed.  Providing an argument will set the desired date;
only the superuser can set the date. The \fI-d\fP and \fI-t\fP
flags set the kernel's values for daylight savings time and
minutes west of GMT.  If \fIdst\fP is non-zero, future calls
to \fIgettimeofday\fP(2) will return a non-zero \fItz_dsttime\fP.
\fIMinutes_west\fP provides the number of minutes returned
by future calls to \fIgettimeofday\fP(2) in \fItz_minuteswest\fP.  The
\fI-u\fP flag is used to display or set the date in GMT (universal) time.
.I yy
represents the last two digits of the year;
the first
.I mm
is the month number;
.I dd
is the day number;
.I hh
is the hour number (24 hour system);
the second
.I mm
is the minute number;
.BI . ss
is optional and represents the seconds.
For example:
.IP
date 8506131627
.PP
sets the date to June 13 1985, 4:27 PM.  The year, month and day may
be omitted; the default values will be the current ones.  The system
operates in GMT.  \fIDate\fP takes care of the conversion to and from
local standard and daylight-saving time.
.PP
If 
.I timed(8)
is running to synchronize the clocks of machines in a local
area network, \fIdate\fP sets the time globally on all those
machines unless the
.B \-n
option is given.
.SH FILES
/usr/adm/wtmp to record time-setting.
In /usr/adm/messages, \fIdate\fP records the name of the user
setting the time.
.SH SEE ALSO
gettimeofday(2), utmp(5), timed(8),
.br
\fITSP: The Time Synchronization Protocol for UNIX 4.3BSD\fP, 
R. Gusella and S. Zatti
.SH DIAGNOSTICS
Exit status is 0 on success, 1 on complete failure to set the date,
and 2 on successfully setting the local date but failing globally.
.PP
Occasionally, when \fItimed\fP synchronizes the time on many hosts, 
the setting of a new time value may require more than a few seconds.
On these occasions, \fIdate\fP prints: `Network time being set'.
The message `Communication error with timed' occurs when the communication
between \fIdate\fP and \fItimed\fP fails.
.SH BUGS
The system attempts to keep the date in a format closely compatible
with VMS.  VMS, however, uses local time (rather than GMT) and does
not understand daylight-saving time.  Thus, if you use both UNIX
and VMS, VMS will be running on GMT.
