.\"	@(#)chmod.1	6.3 (Berkeley) 5/22/86
.\"
.TH CHMOD 1 "May 22, 1986"
.AT 3
.SH NAME
chmod \- change mode
.SH SYNOPSIS
\fBchmod\fP [
.B \-Rf
] mode file ...
.SH DESCRIPTION
The mode of each named file is changed according to \fImode\fP,
which may be absolute or symbolic.  An absolute \fImode\fP
is an octal number constructed from the OR of the following modes:
.TP 10
4000
set user ID on execution
.br
.ns
.TP 10
2000
set group ID on execution
.br
.ns
.TP 10
1000
sticky bit, see
.IR  chmod (2)
.br
.ns
.TP 10
0400
read by owner
.br
.ns
.TP 10
0200
write by owner
.br
.ns
.TP 10
0100
execute (search in directory) by owner
.br
.ns
.TP 10
0070
read, write, execute (search) by group
.br
.ns
.TP 10
0007
read, write, execute (search) by others
.LP
A symbolic \fImode\fP has the form:
.IP
.RI [ who ]
\fIop permission\fP
.RI [ "op permission" "] ..."
.LP
The \fIwho\fP part is a combination of the letters \fBu\fP
(for user's permissions), \fBg\fP (group) and \fBo\fP (other).
The letter \fBa\fP stands for all, or \fBugo.\fP
If \fIwho\fP is omitted, the default is \fIa\fP
but the setting of the file creation mask (see umask(2)) is taken into account.
.LP
\fIOp\fP can be \fB+\fP to add \fIpermission\fP to the file's mode,
\fB\-\fP to take away \fIpermission\fP and \fB=\fP to assign
\fIpermission\fP absolutely (all other bits will be reset).
.LP
\fIPermission\fP is any combination of the letters \fBr\fP (read),
\fBw\fP (write), \fBx\fP (execute),
\fBX\fP (set execute only if file is a directory
or some other execute bit is set),
\fBs\fP (set owner or group id)
and \fBt\fP (save text \- sticky).
Letters \fBu\fP, \fBg\fP, or \fBo\fP indicate that \fIpermission\fP
is to be taken from the current mode. 
Omitting \fIpermission\fP
is only useful with \fB=\fP to take away all permissions.
.PP
When the
.B \-R
option is given, 
.I chmod
recursively descends its directory arguments
setting the mode for each file as described above.
When symbolic links are encountered, their mode is not changed
and they are not traversed.
.PP
If the
.B \-f
option is given,
.I chmod
will not complain if it fails to change the mode
on a file.
.SH EXAMPLES
.LP
The first example denies write permission to others,
the second makes a file executable by all if it is executable by anyone:
.IP
chmod o\-w file
.br
chmod +X file
.LP
Multiple symbolic modes separated by commas may be given.
Operations are performed in the order specified.  The letter
\fBs\fP is only useful with \fBu\fP or \fBg.\fP
.LP
Only the owner of a file (or the super-user) may change its mode.
.SH "SEE ALSO"
ls(1), chmod(2), stat(2), umask(2), chown(8)
