.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)adb.1	6.1 (Berkeley) 4/29/85
.\"
.TH ADB 1 "April 29, 1985"
.UC 4
.SH NAME
adb \- debugger
.SH SYNOPSIS
.B adb
[\fB\-w\fR] [ \fB\-k\fR ] [ \fB-I\fRdir ] [ objfil [ corfil ] ]
.ds TW \v'.25m'\s+2~\s-2\v'-.25m'
.ds ST *
.ds IM \v'.1m'=\v'-.1m'\s-2\h'-.1m'>\h'.1m'\s+2
.ds LE \(<=
.ds LT \s-2<\s+2
.ds GT \s-2>\s+2
.SH DESCRIPTION
.I Adb
is a general purpose debugging program.
It may be used to examine files and to provide
a controlled environment for the execution of UNIX programs.
.PP
.I Objfil
is normally an executable program file, preferably
containing a symbol table; if not then the symbolic features of
.I  adb
cannot be used although the file can still be examined.
The default for
.I objfil
is
.B  a.out.
.I Corfil
is assumed to be a core image file produced after executing
.IR objfil ;
the default for
.I corfil
is
.B  core.
.PP
Requests to
.I  adb
are read from the standard input and responses are to the standard output.
If the
.B  \-w
flag is present then both
.I  objfil
and
.I corfil
are created if necessary and opened for reading and writing
so that files can be modified using
.IR adb .
.PP
The \fB\-k\fP option makes \fIadb\fP do UNIX kernel memory
mapping; it should be used when \fIcore\fP is a UNIX crash dump
or \fI/dev/mem\fP.
.PP
The \fB\-I\fP option specifies a directory where files to be read
with $< or $<< (see below) will be sought; the default is
.IR /usr/lib/adb .
.PP
.I Adb
ignores QUIT; INTERRUPT causes return to the next
.I adb
command.
.PP
In general requests to
.I  adb
are of the form
.PP
.if n .ti 16
.if t .ti 1.6i
[\|\fIaddress\fR\|]  [\|,
.IR count \|]
[\|\fIcommand\fR\|] [\|;\|]
.PP
If
.I address
is present then
.I  dot
is set to
.IR address .
Initially
.I dot
is set to 0.  For most commands
.I count
specifies how many times the command will be executed.  The default
.I count
is 1.
.I Address
and
.I count
are expressions.
.PP
The interpretation of an address depends on the context it is used in.
If a subprocess is being debugged then addresses are interpreted
in the usual way in the address space of the subprocess.
If the operating system is being debugged either post-mortem or using
the special file
.I /dev/mem
to interactive examine and/or modify memory the maps are set to map
the kernel virtual addresses which start at 0x80000000 (on the VAX).
.SM ADDRESSES.
.SH EXPRESSIONS
.TP 7.2n
.B .
The value of
.IR dot .
.TP 7.2n
+
The value of
.I dot
incremented by the current increment.
.TP 7.2n
^
The value of
.I dot
decremented by the current increment.
.TP 7.2n
"
The last
.I address
typed.
.TP 7.2n
.I integer
A number.  The prefixes 0o and 0O (\*(lqzero oh\*(rq) force interpretation
in octal radix; the prefixes 0t and 0T force interpretation in
decimal radix; the prefixes 0x and 0X force interpretation in
hexadecimal radix.  Thus 0o20 = 0t16 = 0x10 = sixteen.
If no prefix appears, then the
.I default\ radix
is used; see the $d command.  The default radix is initially hexadecimal.
The hexadecimal digits are 0123456789abcdefABCDEF with the obvious
values.  Note that a hexadecimal number whose most significant
digit would otherwise be an alphabetic character must have a 0x
(or 0X) prefix (or a leading zero if the default radix is hexadecimal).
.TP 7.2n
.IB integer . fraction
A 32 bit floating point number.
.TP 7.2n
.I \'cccc\|\'
The ASCII value of up to 4 characters.
\e may be used to escape a \'.
.TP 7.2n
.I \*(LT name
The value of
.IR name ,
which is either a variable name or a register name.
.I Adb
maintains a number of variables (see
.SM VARIABLES\*S)
named by single letters or digits.
If
.I name
is a register name then the value of the register is obtained from
the system header in
.IR corfil .
The register names are those printed by the $r command.
.TP 7.2n
.I symbol
A
.I symbol
is a sequence of upper or lower case letters, underscores or
digits, not starting with a digit.  The backslash character
.B \e 
may be used to escape other characters.  The value of the
.I symbol
is taken from the symbol table in
.IR objfil .
An initial \_ will be prepended to
.I symbol
if needed.
.TP
.I _ symbol
In C, the `true name' of an external symbol begins with _.
It may be necessary to utter this name to distinguish it
from internal or hidden variables of a program.
.TP 7.2n
.IB routine . name
The address of the variable
.I name
in the specified C routine.  Both
.I routine
and
.I name
are
.IR symbols .
If
.I name
is omitted the value is the address of the most recently activated C stack frame
corresponding to
.IR routine .
(This form is currently broken on the VAX; local variables can be examined
only with
.IR dbx (1).)
.TP 7.2n
.RI ( exp \|)
The value of the expression
.IR exp .
.LP
.SM
.B  "Monadic\ operators"
.TP 7.2n
.RI \*(ST exp
The contents of the location addressed by
.I exp
in
.IR corfil .
.TP 7.2n
.RI @ exp
The contents of the location addressed by
.I exp
in
.IR objfil .
.TP 7.2n
.RI \- exp
Integer negation.
.TP 7.2n
.RI \*(TW exp
Bitwise complement.
.TP 7.2n
.RI # exp
Logical negation.
.LP
.tr ''
.B  "Dyadic\ operators"
are left associative and are less binding than monadic operators.
.TP 7.2n
.IR e1 + e2
Integer addition.
.TP 7.2n
.IR e1 \- e2
Integer subtraction.
.TP 7.2n
.IR e1 \*(ST e2
Integer multiplication.
.TP 7.2n
.IR e1 % e2
Integer division.
.TP 7.2n
.IR e1 & e2
Bitwise conjunction.
.TP 7.2n
.IR e1 \(bv e2
Bitwise disjunction.
.TP 7.2n
.IR e1 # e2
.I E1
rounded up to the next multiple of
.IR e2 .
.DT
.SH COMMANDS
Most commands consist of a verb followed by a modifier or list of modifiers.
The following verbs are available.
(The commands `?' and `/' may be followed by `\*(ST'; see
.SM ADDRESSES
for further details.)
.TP .5i
.RI ? f
Locations starting at
.I address
in
.I  objfil
are printed according to the format
.IR f .
.I dot
is incremented by the sum of the increments for each format letter (q.v.).
.TP
.RI / f
Locations starting at
.I address
in
.I  corfil
are printed according to the format
.I f
and
.I dot
is incremented as for `?'.
.TP
.RI  = f
The value of
.I address
itself is printed in the styles indicated by the format
.IR f .
(For
.B i 
format `?' is printed for the parts of the instruction that reference
subsequent words.)
.PP
A
.I format
consists of one or more characters that specify a style of printing.
Each format character may be preceded by a decimal integer
that is a repeat count for the format character.
While stepping through a format
.I dot
is incremented by the amount given for each format letter.
If no format is given then the last format is used.
The format letters available are as follows.
.ta 2.5n .5i
.RS
.TP
.BR o "	2"
Print 2 bytes in octal.  All octal numbers output by
.I adb
are preceded by 0.
.br
.ns
.TP
.BR O "	4"
Print 4 bytes in octal.
.br
.ns
.TP
.BR q "	2"
Print in signed octal.
.br
.ns
.TP
.BR Q "	4"
Print long signed octal.
.br
.ns
.TP
.BR d "	2"
Print in decimal.
.br
.ns
.TP
.BR D "	4"
Print long decimal.
.br
.ns
.TP
.BR x "	2"
Print 2 bytes in hexadecimal.
.br
.ns
.TP
.BR X "	4"
Print 4 bytes in hexadecimal.
.br
.ns
.TP
.BR u "	2"
Print as an unsigned decimal number.
.br
.ns
.TP
.BR U "	4"
Print long unsigned decimal.
.br
.ns
.TP
.BR f "	4"
Print the 32 bit value as a floating point number.
.br
.ns
.TP
.BR F "	8"
Print double floating point.
.br
.ns
.TP
.BR b "	1"
Print the addressed byte in octal.
.br
.ns
.TP
.BR c "	1"
Print the addressed character.
.br
.ns
.TP
.BR C "	1"
Print the addressed character using
the standard escape convention where control characters
are printed as ^X and the delete character is printed as ^?.
.br
.ns
.TP
.BI s "	n"
Print the addressed characters until a zero character is reached.
.br
.ns
.TP
.BI S "	n"
Print a string using the ^\fIX\fR escape convention (see \fBC\fR above).
.I n
is the length of the string including its zero terminator.
.br
.ns
.TP
.BR Y "	4"
Print 4 bytes in date format (see
.IR ctime (3)).
.br
.ns
.TP
.BR i "	n"
Print as machine instructions.
.I n
is the number of bytes occupied by the instruction.
This style of printing causes variables 1 and 2 to be set
to the offset parts of the source and destination respectively.
.br
.ns
.TP
.BR a "	0"
Print the value of
.I dot
in symbolic form.
Symbols are checked to ensure that they have an appropriate
type as indicated below.
.LP
	/	local or global data symbol
.br
	?	local or global text symbol
.br
	=	local or global absolute symbol
.TP
.BR p "	4"
Print the addressed value in symbolic form using
the same rules for symbol lookup as
.BR a .
.br
.tr ''
.ns
.TP
.BR t "	0"
When preceded by an integer tabs to the next appropriate tab stop.
For example,
.B 8t 
moves to the next 8-space tab stop.
.br
.ns
.TP
.BR r "	0"
Print a space.
.br
.ns
.TP
.BR n "	0"
Print a newline.
.br
.ns
.tr '"
.TP
.BR '...' " 0"
Print the enclosed string.
.br
.tr ''
.br
.ns
.TP
.B ^
.I Dot
is decremented by the current increment.  Nothing is printed.
.br
.ns
.TP
+
.I Dot
is incremented by 1.  Nothing is printed.
.br
.ns
.TP
\-
.I Dot
is decremented by 1.  Nothing is printed.
.RE
.TP
newline
Repeat the previous command with a
.I count
of 1.
.TP
.RB [ ?/ ] l "\fI value mask\fR"
Words starting at
.I  dot
are masked with
.I mask
and compared with
.I value
until a match is found.
If
.B L
is used then the match is for 4 bytes at a time instead of 2.
If no match is found then
.I dot
is unchanged; otherwise
.I dot
is set to the matched location.
If
.I mask
is omitted then \-1 is used.
.TP
.RB [ ?/ ] w "\fI value ...\fR"
Write the 2-byte
.I value
into the addressed location.  If the command is
.BR W ,
write 4 bytes.
Odd addresses are not allowed when writing to the subprocess address space.
.TP
[\fB?/\fR]\fBm\fI b1 e1 f1\fR[\fB?/\fR]
.br
New values for
.RI ( b1,\ e1,\ f1 )
are recorded.  If less than three expressions are given then
the remaining map parameters are left unchanged.
If the `?' or `/' is followed by `\*(ST' then
the second segment (\fIb2\fR\|,\|\fIe2\fR\|,\|\fIf2\fR)
of the mapping is changed.
If the list is terminated by `?' or `/' then the file (\fIobjfil\fR or
.I corfil
respectively) is used for subsequent requests.
(So that, for example, `/m?' will cause `/' to refer to
.IR objfil .)
.TP
.BI \*(GT name
.I Dot
is assigned to the variable or register named.
.TP
.B !
A shell (/bin/sh) is called to read the rest of the line following `!'.
.TP
.RI $ modifier
Miscellaneous commands.  The available 
.I modifiers 
are:
.RS
.TP
.BI < f
Read commands from the file
.IR f .
If this command is executed in a file, further commands
in the file are not seen.
If
.I f
is omitted, the current input stream is terminated.  If a
.I count
is given, and is zero, the command will be ignored.
The value of the count will be placed in variable
.I 9
before the first command in
.I f
is executed.
.br
.ns
.TP
.BI << f
Similar to
.B <
except it can be used in a file of commands without
causing the file to be closed.  Variable
.I 9
is saved during the execution of this command, and restored when it completes.
There is a (small) finite limit to the number of
.B <<
files that can be open at once.
.br
.ns
.TP
.BI > f
Append output to the file
.IR f ,
which is created if it does not exist.  If
.I f
is omitted, output is returned to the terminal.
.br
.ns
.TP
.B ?
Print process id, the signal which caused stoppage or termination,
as well as the registers as \fB$r\fR.  This is the default if
\fImodifier\fR is omitted.
.br
.ns
.TP
.B r
Print the general registers and the instruction addressed by
.BR pc .
.I Dot
is set to \fBpc\fR.
.br
.ns
.TP
.B b
Print all breakpoints and their associated counts and commands.
.br
.ns
.TP
.B c
C stack backtrace.  If
.I address
is given then it is taken as the address of the current frame 
instead of the contents of the frame\-pointer register.  If
.B C 
is used then the names and (32 bit) values of all automatic
and static variables are printed for each active function. (broken
on the VAX).  If
.I count
is given then only the first
.I count
frames are printed.
.br
.ns
.TP
.B d
Set the default radix to
.I address
and report the new value.  Note that
.I address
is interpreted in the (old) current radix.
Thus \*(lq10$d\*(rq never changes the default radix.
To make decimal the default radix, use \*(lq0t10$d\*(rq.
.br
.ns
.TP
.B e
The names and values of external variables are printed.
.br
.ns
.TP
.B w
Set the page width for output to
.I address
(default 80).
.br
.ns
.TP
.B s
Set the limit for symbol matches to
.I address
(default 255).
.br
.ns
.TP
.B o
All integers input are regarded as octal.
.br
.ns
.TP
.B q
Exit from
.IR adb .
.br
.ns
.TP
.B v
Print all non zero variables in octal.
.br
.ns
.TP
.B m
Print the address map.
.br
.ns
.TP
.B p
.RI ( "Kernel debugging" )
Change the current kernel memory mapping to map the designated 
.B "user structure"
to the address given by the symbol
.I "_u."
The
.I address
argument is the address of the user's user page table entries (on
the VAX).
.RE
.TP
.BI : modifier
Manage a subprocess.  Available modifiers are:
.RS
.TP
.BI b c
Set breakpoint at
.IR address .
The breakpoint is executed
.IR count \-1
times before causing a stop.
Each time the breakpoint is encountered the command
.I c
is executed.  If this command is omitted or sets
.I dot
to zero then the breakpoint causes a stop.
.TP
.B d
Delete breakpoint at
.IR address .
.TP
.B r
Run
.I objfil
as a subprocess.  If
.I address
is given explicitly then the program is entered at this point; otherwise
the program is entered at its standard entry point.
.I count
specifies how many breakpoints are to be ignored before stopping.
Arguments to the subprocess may be supplied on the same line as the command.
An argument starting with < or > causes the standard
input or output to be established for the command.
.TP
.BI c s
The subprocess is continued with signal
.I s,
see
.IR sigvec (2).
If
.I address
is given then the subprocess is continued at this address.
If no signal is specified then the signal
that caused the subprocess to stop is sent.
Breakpoint skipping is the same as for
.BR r .
.TP
.BI s s
As for
.B c 
except that the subprocess is single stepped
.I count
times.  If there is no current subprocess then
.I objfil
is run as a subprocess as for
.BR r .
In this case no signal can be sent; the remainder of the line
is treated as arguments to the subprocess.
.TP
.B k
The current subprocess, if any, is terminated.
.RE
.SH VARIABLES
.I Adb
provides a number of variables.
Named variables are set initially by
.I  adb
but are not used subsequently.
Numbered variables are reserved for communication as follows.
.TP
0
The last value printed.
.br
.ns
.TP
1
The last offset part of an instruction source.
.br
.ns
.TP
2
The previous value of variable 1.
.br
.ns
.TP
9
The count on the last $< or $<< command.
.PP
On entry the following are set from the system header in the
.IR corfil .
If
.I corfil
does not appear to be a
.B core 
file then these values are set from
.IR objfil .
.TP
b
The base address of the data segment.
.br
.ns
.TP
d
The data segment size.
.br
.ns
.TP
e
The entry point.
.br
.ns
.TP
m
The `magic' number (0407, 0410 or 0413).
.br
.ns
.TP
s
The stack segment size.
.br
.ns
.TP
t
The text segment size.
.SH ADDRESSES
The address in a file associated with
a written address is determined by a mapping associated with that file.
Each mapping is represented by two triples
.RI ( "b1, e1, f1" )
and
.RI ( "b2, e2, f2" )
and the
.I file address
corresponding to a written
.I address
is calculated as follows.
.PP
.if t .ti 1.5i
.if n .ti 8
.IR b1 \*(LE address < e1
\*(IM
.IR "file address" = address + f1\-b1,
otherwise,
.PP
.if t .ti 1.5i
.if n .ti 8
.IR b2 \*(LE address < e2
\*(IM
.IR "file address" = address + f2\-b2,
.PP
otherwise, the requested
.I address
is not legal.  In some cases (e.g. for programs with separated I and D
space) the two segments for a file may overlap.  If a
.B ? 
or
.B / 
is followed by an
.B \*(ST 
then only the second triple is used.
.PP
The initial setting of both mappings is suitable for normal
.B a.out 
and
.B core 
files.  If either file is not of the kind expected then, for that file,
.I b1
is set to 0,
.I e1
is set to the maximum file size and
.I f1
is set to 0; in this way the whole
file can be examined with no address translation.
.PP
.SH FILES
a.out
.br
core
.SH SEE\ ALSO
cc(1),
dbx(1),
ptrace(2),
a.out(5),
core(5)
.SH DIAGNOSTICS
`Adb' when there is no current command or format.
Comments about inaccessible files, syntax errors,
abnormal termination of commands, etc.
Exit status is 0, unless last command failed or returned nonzero status.
.SH BUGS
Since no shell is invoked to interpret the arguments of the
.B :r
command, the customary wild-card and variable expansions cannot occur.
