/*
 *			D U N N . G
 *
 * Created from flipflop.g to compensate for Dunn camera problem with
 * 16mm camera and Yoke inverter.
 *  -Mike Muuss
 *
 * Name: flipflop.g
 * Date: 17-Apr-84
 * Purpose: Gia2 demo. This program flips (top to bottom) and flops (left
 *	to right the current image by reading and writing frame buffer pixels.
 * Author: Steve Satterfield
 */

#include "pixops.h"

main()
{
	doit();
}

doit()
{
	register int i,p;	  /* loop variables */
	register int b,t;	  /* scan line indicators */
	register int l,r;	  /* scan line indicators */
	register int upper,lower; /* store the upper and lower pixel values */
	register int upper2,lower2; /* store the upper and lower pixel values */
	register int left,right;  /* store the left and right pixel values */
	register int x,y;

	b = 255;	/* Start at center scan lines */
	t = 256;
	l = 255;	/* and center pixels */
	r = 256;

	for (i=0; i<256; i++) {
		/* Do vertical */
		for (y=256; y<t; y++) {
			p = 511-y;
			getpixel(l,y, upper);
			getpixel(l,p, lower);
			getpixel(r,y, upper2);
			getpixel(r,p, lower2);

			putpixel(l,y, lower2);
			putpixel(l,p, upper2);
			putpixel(r,y, lower);
			putpixel(r,p, upper);
			}
		/* Do horizontal */
		for (x=l; x<256; x++) {
			p = 511-x;
			getpixel(x,t, upper);
			getpixel(p,t, lower);
			getpixel(x,b, upper2);
			getpixel(p,b, lower2);

			putpixel(x,t, lower2);
			putpixel(p,t, upper2);
			putpixel(x,b, lower);
			putpixel(p,b, upper);
			}
		b--;
		t++;
		l--;
		r++;
		}
}
