/*
 *			E R R O R
 *
 *  Ray Tracing library, error handling routines.
 *  Note that the user may provide his own error handlers.
 *
 *  Functions -
 *	rt_bomb		Called upon fatal library error.
 *	rt_log		Called to log library events.
 *
 *  Author -
 *	Michael John Muuss
 *  
 *  Source -
 *	SECAD/VLD Computing Consortium, Bldg 394
 *	The U. S. Army Ballistic Research Laboratory
 *	Aberdeen Proving Ground, Maryland  21005
 *  
 *  Copyright Notice -
 *	This software is Copyright (C) 1985 by the United States Army.
 *	All rights reserved.
 */
#ifndef lint
static char RCSid[] = "@(#)$Header: error.c,v 3.0 86/06/10 01:33:08 mike Exp $ (BRL)";
#endif

#include <stdio.h>
#include <varargs.h>
#include "../h/machine.h"
#include "../h/vmath.h"
#include "../h/raytrace.h"
#include "debug.h"

/*
 *			R T _ B O M B
 *  
 *  Abort the RT library
 */
void
rt_bomb(str)
char *str;
{
	fprintf(stderr,"\n%s\n", str);
	rt_log("rt:  Fatal Error, aborting\n");
	fflush(stderr);
	abort();	/* should dump */
	exit(12);
}

/*
 *  			R T _ L O G
 *  
 *  Log an RT library event
 */
/* VARARGS */
void
rt_log(va_alist)
va_dcl
{
	va_list ap;
	char *fmt;
	int a,b,c,d,e,f,g;

	va_start(ap);
	fmt = va_arg(ap,char *);
	a = va_arg(ap,int);
	b = va_arg(ap,int);
	c = va_arg(ap,int);
	d = va_arg(ap,int);
	e = va_arg(ap,int);
	f = va_arg(ap,int);
	g = va_arg(ap,int);
	va_end(ap);
	/* We use the same lock as malloc.  Sys-call or mem lock, really */
	RES_ACQUIRE( &rt_g.res_malloc );		/* lock */
	fprintf(stderr, fmt, a,b,c,d,e,f,g );
	RES_RELEASE( &rt_g.res_malloc );		/* unlock */
}
