/*
 *  			C U T . H
 *  
 *  Structure for space subdivision.
 *
 *  Author -
 *	Michael John Muuss
 *  
 *  Source -
 *	SECAD/VLD Computing Consortium, Bldg 394
 *	The U. S. Army Ballistic Research Laboratory
 *	Aberdeen Proving Ground, Maryland  21005
 *  
 *  Copyright Notice -
 *	This software is Copyright (C) 1985 by the United States Army.
 *	All rights reserved.
 *
 *  $Header: cut.h,v 3.0 86/06/10 01:31:59 mike Exp $
 */
union cutter  {
#define CUT_CUTNODE	1
#define CUT_BOXNODE	2
	char	cut_type;
	union cutter *cut_forw;		/* Freelist forward link */
	struct cutnode  {
		char	cn_type;
		char	cn_axis;	/* 0,1,2 = cut along X,Y,Z */
		fastf_t	cn_point;	/* cut through axis==point */
		union cutter *cn_l;	/* val < point */
		union cutter *cn_r;	/* val >= point */
	} cn;
	struct boxnode  {
		char	bn_type;
		fastf_t	bn_min[3];
		fastf_t	bn_max[3];
		struct soltab **bn_list;
		short	bn_len;		/* # of solids in list */
		short	bn_maxlen;	/* # of ptrs allocated to list */
	} bn;
};
#define CUTTER_NULL	((union cutter *)0)
extern union cutter CutHead;
extern union cutter *CutFree;
