


     MATH(M)		    Altos UNIX System V		       MATH(M)



     Name
	  math - math functions	and constants

     Syntax
	  #include <math.h>

     Description
	  This file contains declarations of all the functions in the
	  Development System Math Library as well as various functions
	  in the C Library that	return floating-point values.

	  It defines the structure and constants used by the
	  matherr(S) error-handling mechanisms,	including the
	  following constant used as an	error-return value:

	  HUGE		      The maximum value	of a single-precision
			      floating-point number.

	  The following	mathematical constants are defined for user
	  convenience:

	  M_E		      The base of natural logarithms (e).

	  M_LOG2E	      The base-2 logarithm of e.

	  M_LOG10E	      The base-10 logarithm of e.

	  M_LN2		      The natural logarithm of 2.

	  M_LN10	      The natural logarithm of 10.

	  M_PI		      n, the ratio of the circumference	of a
			      circle to	its diameter.

	  M_PI_2	      n/2.

	  M_PI_4	      n/4.

	  M_1_PI	      1/n.

	  M_2_PI	      2/n.

	  M_2_SQRTPI	      2/\/n.

	  M_SQRT2	      The positive square root of 2.

	  M_SQRT1_2	      The positive square root of 1/2.

	  For the definitions of various machine-dependent
	  ``constants,'' see the description of	the <values.h> header
	  file.




     Page 1					     (printed 3/20/91)






     MATH(M)		    Altos UNIX System V		       MATH(M)



     See Also
	  intro(S), matherr(S),	values(M)

     Standards Conformance
	  math is conformant with:
	  The X/Open Portability Guide II of January 1987.

















































     Page 2					     (printed 3/20/91)



