


     MEISA(F)		    Altos UNIX System V		      MEISA(F)



     Name
	  meisa	- master EISA system kernel configuration file

     Description
	  The meisa file is used by uconfig(ADM) and idconfig(ADM) to
	  maintain a mapping between EISA hardware functions and UNIX
	  device drivers.  Each	line in	the meisa file specifies one
	  such mapping.

	  Each line must contain the following five fields, each
	  separated by a whitespace:

	       dev_name	flags EISA_ID EISA_type	majors

	  Each field is	described below:

	  dev_name  This field contains	the internal name of the
		    driver.  This name must match the names in the
		    first field	of an mdevice file entry.  If this
		    field contains a single dash character (-),	then
		    the	EISA function specified	later in this line (in
		    func_type) will not	be mapped to a device driver
		    (uconfig will ignore this EISA function).

	  flags	    This field is a string of characters that identify
		    some special driver	characteristics.  If no	flags
		    are	specified, the field should contain a single
		    dash character (-).	 The legal flag	characters are
		    listed below:

		    f  Indicates that this driver contains an EISA NMI
		       (non-maskable interrupt)	failure-handling
		       routine.

		    i  Indicates that there is an associated shell
		       script that sets	up the
		       /etc/conf/init.d/dev_name file.	This shell
		       script will be invoked by uconfig with the
		       appropriate arguments.

		    n  Indicates that there is an associated shell
		       script that sets	up the
		       /etc/conf/node.d/dev_name file.	This shell
		       script will be invoked by uconfig with the
		       appropriate arguments.

	  EISA_ID   This field contains	the EISA board ID string that
		    is associated with the driver.  The	EISA ID	can be
		    described in this field as a regular expression
		    (see ed(C)).  For example, the regular expression
		    ACS02[0-9].	will match EISA	IDs such as ACS0200,
		    ACS0201, ACS0211, etc.  This field is mandatory.



     Page 1					      (printed 6/6/91)






     MEISA(F)		    Altos UNIX System V		      MEISA(F)



	  EISA_type This field contains	the EISA function type string
		    that is associated with the	driver.	 This string
		    can	be a simple EISA type (for example, COM,MDC),
		    or may include subtype information (such as
		    COM,ASY;COM1).  The	EISA type string can be
		    described in this field as a regular expression
		    (see ed(C)).  For example, the regular expression
		    COM.[A-Z]* will match any EISA type	string that
		    begins with	COM, and is followed by	zero or	more
		    upper-case letters.

		    If the hardware function is	not defined with an
		    EISA type string, the following syntax may be
		    used:

			 <func_no>

		    where func_no is the function number of the
		    particular EISA board.  For	example, <5> specifies
		    function 5.	 For a pseudo-driver that does not
		    directly drive a hardware function,	this field
		    should be a	single dash character (-).

	  majors    This field normally	should be 0 (zero), except for
		    drivers with multiple major	device numbers.	 In a
		    such a case, this field should contain the number
		    of major numbers occupied per instance of the
		    hardware function.

     Files
	  /etc/conf/cf.d/meisa

     See Also
	  uconfig(ADM),	mdevice(F), sdevice(F)

     Notes
	  The regular expressions in the EISA_ID and EISA_type fields
	  cannot contain any whitespace	or the following three
	  metacharacters: ( ) $

	  No more than one NMI failure handling	routine	may be
	  specified for	functions in a single EISA slot.

     Value Added
	  meisa	is an extension	to AT&T	UNIX System V provided in
	  Altos	UNIX System V.









     Page 2					      (printed 6/6/91)



