


     DD(C)		    Altos UNIX System V			 DD(C)



     Name
	  dd - converts	and copies a file

     Syntax
	  dd [option=value] ...

     Description
	  dd copies the	specified input	file to	the specified output
	  with possible	conversions.  The standard input and output
	  are used by default.	The input and output block size	may be
	  specified to take advantage of raw physical I/O.

	  Option	     Value

	  if=file	     Input filename; standard input is default

	  of=file	     Output filename; standard output is
			     default

	  ibs=n		     Input block size is n bytes (default is
			     BSIZE block size)

	  obs=n		     Output block size (default	is BSIZE block
			     size)

	  bs=n		     Sets both input and output	block size,
			     superseding ibs and obs.  If no
			     conversion	is specified, it is
			     particularly efficient since no in-core
			     copy needs	to be done

	  cbs=n		     Conversion	buffer size

	  skip=n	     Skips n input records before starting
			     copy

	  seek=n	     Seeks n records from beginning of output
			     file before copying

	  count=n	     Copies only n input records

	  conv=ascii	     Converts EBCDIC to	ASCII

	  conv=ebcdic	     Converts ASCII to EBCDIC

	  conv=ibm	     Slightly different	map of ASCII to	EBCDIC

	  conv=lcase	     Maps alphabetic characters	to lowercase







     Page 1					     (printed 3/20/91)






     DD(C)		    Altos UNIX System V			 DD(C)



	  Option	     Value

	  conv=ucase	     Maps alphabetic characters	to uppercase

	  conv=swab	     Swaps every pair of bytes

	  conv=sync	     Pads every	input record to	ibs

	  conv="... , ..."   Several comma-separated conversions

	  Where	sizes are specified, a number of bytes is expected.  A
	  number may end with k, b, or w to specify multiplication by
	  1024,	512, or	2 respectively;	a pair of numbers may be
	  separated by x to indicate a product.

	  cbs is used only if ascii or ebcdic conversion is specified.
	  In the former	case cbs characters are	placed into the
	  conversion buffer, converted to ASCII, and trailing blanks
	  trimmed and newline added before sending the line to the
	  output.  In the latter case ASCII characters are read	into
	  the conversion buffer, converted to EBCDIC, and blanks added
	  to make up an	output record of size cbs.

	  After	completion, dd reports the number of whole and partial
	  input	and output blocks.

     Examples
	  This command reads an	EBCDIC tape, blocked ten 80-byte
	  EBCDIC card images per record, into the ASCII	file outfile:

	       dd  if=/dev/rmt0	 of=outfile  ibs=800  cbs=80  conv=ascii,lcase

	  Note the use of raw magtape.	dd is especially suited	to I/O
	  on raw physical devices because it allows reading and
	  writing in arbitrary record sizes.

     See Also
	  copy(C), cp(C), tar(C)

     Diagnostics
	  f+p records in(out)	  Numbers of full and partial records
				  read(written)

     Notes
	  The ASCII/EBCDIC conversion tables are taken from the	256-
	  character standard in	the CACM Nov, 1968.  The ibm
	  conversion corresponds better	to certain IBM print train
	  conventions.	There is no universal solution.

	  Newlines are inserted	only on	conversion to ASCII; padding
	  is done only on conversion to	EBCDIC.




     Page 2					     (printed 3/20/91)






     DD(C)		    Altos UNIX System V			 DD(C)



	  When using dd	with a raw device, specify the block size as a
	  multiple of 512-byte blocks.	For example, to	use a 9K block
	  size,	enter:

	       dd if=file of=/dev/rfd0 bs=18b

	  You could also enter:

	       dd if=file of=/dev/rfd0 bs=9K

     Standards Conformance
	  dd is	conformant with:
	  AT&T SVID Issue 2, Select Code 307-127;
	  and The X/Open Portability Guide II of January 1987.









































     Page 3					     (printed 3/20/91)



