


     BC(C)		    Altos UNIX System V			 BC(C)



     Name
	  bc - invokes a calculator

     Syntax
	  bc [ -c ] [ -l ] [ file ... ]

     Description
	  bc is	an interactive processor for a language	that resembles
	  C but	provides unlimited precision arithmetic.  It takes
	  input	from any files given, then reads the standard input.
	  The -l argument stands for the name of an arbitrary
	  precision math library.  The syntax for bc programs is as
	  follows:  L means the	letters	a-z, E means expression, S
	  means	statement.

	  Comments:

	      Enclosed in /* and */

	  Names:

	      Simple variables:	L
	      Array elements: L	[ E ]
	      The words	``base'', ``ibase'', ``obase'',	and ``scale'';
	      ``base'' and ``ibase'' are interchangeable.

	  Other	operands:

	      Arbitrarily long numbers with optional sign and decimal
	      point
	      (	E )
	      sqrt ( E )
	      length ( E )   Number of significant decimal digits
	      scale ( E	)    Number of digits right of decimal point
	      L	( E , ... , E )

	  Additive operators:

	      +
	      -

	  Multiplicative operators:

	      *
	      /
	      %	(remainder)
	      ^	(exponentiation)








     Page 1					     (printed 3/20/91)






     BC(C)		    Altos UNIX System V			 BC(C)



	  Unary	operators:

	      ++
	      -	-  (prefix and postfix;	apply to names)

	  Relational operators:

	      ==
	      <=
	      >=
	      !=
	      <
	      >

	  Assignment operators:

	      =
	      =+
	      =-
	      =*
	      =/
	      =%
	      =^

	  Statements:

	      E
	      {	S ; ...	; S }
	      if ( E ) S
	      while ( E	) S
	      for ( E ;	E ; E )	S
	      null statement
	      break
	      quit

	  Function definitions:

	      define L ( L ,..., L ) {
		   auto	L, ... , L
		   S; ... S
		   return ( E )
	      }













     Page 2					     (printed 3/20/91)






     BC(C)		    Altos UNIX System V			 BC(C)



	  Functions in -l math library:

	      s(x) Sine
	      c(x) Cosine
	      e(x) Exponential
	      l(x) Log
	      a(x) Arctangent
	      j(n,x)	Bessel function

	  All function arguments are passed by value.

	  The value of a statement that	is an expression is printed
	  unless the main operator is an assignment.  Either
	  semicolons or	newlines may separate statements.  Assignment
	  to scale influences the number of digits to be retained on
	  arithmetic operations	in the manner of dc(C).	 Assignments
	  to ibase or obase set	the input and output number radix
	  respectively.

	  The same letter may be used as an array, a function, and a
	  simple variable simultaneously.  All variables are global to
	  the program.	``Auto'' variables are pushed down during
	  function calls.  When	using arrays as	function arguments or
	  defining them	as automatic variables,	empty square brackets
	  must follow the array	name.

	  bc is	actually a preprocessor	for dc(C), which it invokes
	  automatically, unless	the -c (compile	only) option is
	  present.  If the -c option is	present, the dc	input is sent
	  to the standard output instead.

     Example
	  The following	defines	a function to compute an approximate
	  value	of the exponential function:

	       scale = 20
	       define e(x){
		    auto a, b, c, i, s
		    a =	1
		    b =	1
		    s =	1
		    for(i=1; 1==1; i++){
			 a = a*x
			 b = b*i
			 c = a/b
			 if(c == 0) return(s)
			 s = s+c
		    }
	       }






     Page 3					     (printed 3/20/91)






     BC(C)		    Altos UNIX System V			 BC(C)



	  The following	prints the approximate values of the
	  exponential function of the first ten	integers:

	       for(i=1;	i<=10; i++) e(i)

     Files
	  /usr/lib/lib.bc     Mathematical library

	  /usr/bin/dc	 Desk calculator proper

     See Also
	  dc(C)
	  User's Guide

     Notes
	  A For	statement must have all	three E's.

	  Quit is interpreted when read, not when executed.

	  Trigonometric	values should be given in radians.



































     Page 4					     (printed 3/20/91)



