


     ASSIGN(C)		    Altos UNIX System V		     ASSIGN(C)



     Name
	  assign, deassign - assigns and deassigns devices

     Syntax
	  assign [ -u ]	[ -v ] [ -d ] [	device ] ...

	  deassign [ -u	] [ -v ] [ device ] ...

     Description
	  assign attempts to assign device to the current user.	 The
	  device argument must be an assignable	device that is not
	  currently assigned.  An assign command without an argument
	  prints a list	of assignable devices along with the name of
	  the user to whom they	are assigned.

	  deassign is used to ``deassign'' devices.  Without any
	  arguments, deassign will deassign all	devices	assigned to
	  the user.  When arguments are	given, an attempt is made to
	  deassign each	device given as	an argument.

	  With these commands you can exclusively use a	device,	such
	  as a tape drive or floppy drive.  This keeps other users
	  from using the device.  They have a similar effect as
	  chown(C) and chmod(C), although they only act	on devices in
	  /dev.	 Other aspects are discussed further on.

	  Available options include:

	  -d   Performs	the action of deassign.	 The -d	option can be
	       embedded	in device names	to assign some devices and
	       deassign	others.

	  -v   Gives verbose output.

	  -u   Suppresses assignment or	deassignment, but performs
	       error checking.

	  The assign command will not assign any assignable devices if
	  it cannot assign all of them.	 deassign gives	no diagnostic
	  if the device	cannot be deassigned.  Devices can be
	  automatically	deassigned at logout, but this is not
	  guaranteed.  Device names can	be just	the beginning of the
	  device required.  For	example,

	       assign fd

	  should be used to assign all floppy disk devices.  Raw
	  versions of device will also be assigned, e.g., the raw
	  floppy disk devices /dev/rfd?	would be assigned in the above
	  example.

	  Note that in many installations the assignable devices such



     Page 1					     (printed 3/20/91)






     ASSIGN(C)		    Altos UNIX System V		     ASSIGN(C)



	  as floppy disks have general read and	write access, so the
	  assign command may not be necessary. This is particularly
	  true on single-user systems. Devices supposed	to be
	  assignable with this command should be owned by the user
	  asg.	The directory /dev should be owned by bin and have
	  mode 755. The	assign command (after checking for use by
	  someone else)	will then make the device owned	by whoever
	  invokes the command, without changing	the access
	  permissions. This allows the system administrator to set up
	  individual devices that are freely available,	assignable
	  (owned by asg), or nonassignable and restricted (not owned
	  by asg and with some restricted mode).

	  Note that the	first time assign is invoked, it builds	the
	  assignable devices table /etc/atab.  This table is used in
	  subsequent invocations to save repeated searches of the /dev
	  directory. If	one of the devices in /dev is changed to be
	  assignable or	unassignable (i.e., owned by asg), then
	  /etc/atab should be removed (by the super-user) so that a
	  correct list will be built the next time the command is
	  invoked.

     Files
	  /etc/atab Table of assignable	devices
	  /dev/asglock	 File to prevent concurrent access

     Diagnostics
	  Exit code 0 returned if successful, 1	if problems, 2 if
	  device cannot	be assigned.


























     Page 2					     (printed 3/20/91)



