
#
# segdev.awk (Online Diagnostics)
#

{
notdev = 1;
if ($1 !~ /[^0-9]/) 
   count = $1 + 0;
else 
   count = 1;

for (i=1; i <= NF; i++) {
   if (($i=="Sdsk:")||($i=="floppy")||($i=="floppy:")||($i=="Stp:")||($i=="sio:")) 
     {
       if ($i == "floppy")
         {
	  status="";
	  cmd="";
	  for (j=i+3; j <= NF; j++) 
            {
	     if (substr($j,1,7) == "status=") 
	        status=substr($j,15,1);

	     if (substr($j,1,4) == "cmd=") 
	        cmd=substr($j,12,1);

             if ((cmd) && (status)) break; 
	    }

	  generic=1;
	  if ((cmd=="0") && (status=="3")) {
	     printf("%d fdopen - -\n", count);
	     generic=0;
	  } else if ((status=="2") && ((cmd=="3") || (cmd=="5"))) {
	     printf("%d fdfmt - -\n", count);
	     generic=0;
          }

	  if (generic) 
	    printf("%d fdgen -\n", count);

         }

       else if ($i == "floppy:")
         { 
	   emsg = "";
	   for (jj=i+1; jj<=NF; jj++) 
	     emsg = emsg " " $jj;

	   generic=1;
	   if (emsg == " disk is write protected") {
	        printf("%d fdprot - -\n", count);
	        generic=0;
	   } else if (emsg == " CMOS indicates no diskette drives installed") {
	        printf("%d fdndi - -\n", count);
	        generic=0;
	   } else if(emsg ~ / CMOS indicates diskette drive [0-9] not present/){
                split(emsg,arr)
	        printf("%d fddnp disk# %s\n", count, arr[5]);
	        generic=0;
	   } else if (emsg == " cmd result error") {
	        printf("%d fdcio - -\n", count);
	        generic=0;
           }

	   if (generic) 
	     printf("%d fdgen - -\n", count);
         }

       else if ($i == "Stp:")
         { 
	   emsg = "";
	   for (jj=i+1; jj<=NF; jj++) 
	     emsg = emsg " " $jj;

	   generic=1;
	   if (emsg == " could not allocate buffer") {
	        printf("%d tpbuf - -\n", count);
	        generic=0;
	   } else if (emsg == " rewind failed") {
	        printf("%d tprew - -\n", count);
	        generic=0;
           }

	   if (generic) 
	     printf("%d tpgen - -\n", count);

	 }

       else if ($i == "Sdsk:")
         { 
	   emsg = "";
	   for (jj=i+1; jj<=NF; jj++) 
	     emsg = emsg " " $jj;

	   generic=1;
	   if (emsg ~ / Disk unit [0-9]* not present/) {
 		split(emsg, arr)
	        printf("%d hddnp unit %s\n", count, arr[3]);
	        generic=0;
	   } else if (emsg ~ / unit [0-9]*\: device not ready/) {
 		split(emsg, arr)
	        printf("%d hddnr unit %s\n", count, arr[2]);
	        generic=0;
	   } else if (emsg ~ / spurious interrupt/) {
	        printf("%d hdsint - -\n", count);
	        generic=0;
           }

	   if (generic) 
	     printf("%d hdgen - -\n", count);

	 }

       else if ($i == "sio:")
         { 
	   emsg = "";
	   for (jj=i+1; jj<=NF; jj++) 
	     emsg = emsg " " $jj;

	   generic=1;

	   if (generic) 
	     printf("%d siogen - -\n", count);

	 }
    }

   }
    if (notdev) 
      print $0
}

