
#
# mparse.awk (Online Diagnostics)
#

BEGIN {
  
#
# Determine if current year is a leap year
#
PASTDAYS=3
"date" | getline temp_date          # get system date in standard format
split(temp_date, tdate, " ")
current_year=tdate[6]             
"date '+%m-%d-%y'" | getline current_date  # get system date in mm-dd-yy format
split(current_date, darray, "-")

if (current_year % 4)
  is_leap = 0
else
  is_leap = 1

current_days = past_days = date2daze(darray[1], darray[2])
past_days -= PASTDAYS

if (past_days <= 0)
  {
   past_days = year_bound(past_days)
   yearbound=1
  }

}

/^Mon/ || /^Tue/ || /^Wed/ || /^Thu/ || /^Fri/ || /^Sat/ || /^Sun/ { 
tempdate = $0
next 
} 

/^WARNING/ || /^NOTICE/ || /^PANIC/ || /^ERROR/ || /^DANGER/ { 
temperror = $0
split(tempdate, err_date, " ")


#
# convert month string into its numerical representation
#
if (err_date[2] ~ /Jan/)
   the_month="01"
else if (err_date[2] ~ /Feb/)
   the_month="02"
else if (err_date[2] ~ /Mar/)
   the_month="03"
else if (err_date[2] ~ /Apr/)
   the_month="04"
else if (err_date[2] ~ /May/)
   the_month="05"
else if (err_date[2] ~ /Jun/)
   the_month="06"
else if (err_date[2] ~ /Jul/)
   the_month="07"
else if (err_date[2] ~ /Aug/)
   the_month="08"
else if (err_date[2] ~ /Sep/)
   the_month="09"
else if (err_date[2] ~ /Oct/)
   the_month=10
else if (err_date[2] ~ /Nov/)
   the_month=11
else if (err_date[2] ~ /Dec/)
   the_month=12

#
# preappend single digit months with a leading 0
#
if (err_date[3] < 10)
  day="0" err_date[3] ""
else
  day=err_date[3]

#
# convert date into number of days into the year
#
err_days=date2daze(the_month, day) 

if (yearbound)
  {
   if ((err_days >= past_days) || (err_days <= current_days))
     {
      error_file(the_month, day) 
      write_msg()
     }
  }
else 
  {
   if ((err_days >= past_days) && (err_days <= current_days))
     {
      error_file(the_month, day) 
      write_msg()
     }
  }
  
}

#
# function error_file creates the error file name i.e. error.mm-dd
#
function error_file(month, day)
{
   errorfile="error." month "-" day   
} 	

#
# function write_msg writes the error msg out to the error file
#
function write_msg() 
{

   errout_file="/usr/adm/streams/" errorfile
   printf("%s\n", temperror) >> errout_file

}


#
# function date2daze convert the month and the day into the amount of days
# into the year i.e. 02-05-90 = 36 days
#
function date2daze(mon, d)
{

days=0
for (i = mon-1; i > 0; i--)
   {        
    if ((i == 04) || (i == 06) || (i == 09) || (i == 11)) 
      days += 30
    else if (i == 02)
      if (is_leap)
        days += 29
      else
        days += 28

    else
      days += 31
  }

return days += d 

}


#
# adjust number of days if on a year boundary
#
function year_bound(p_days)
{

if (p_days == 0) 
  if (is_leap)
    p_days = 366
  else
    p_days = 365
else if (p_days < 0)
  if (is_leap)
    p_days += 366
  else
    p_days += 365

return p_days

}




